package net.minecraft.src;

public class NMTTextureVertex
{
	public NMTVertex vertex;
	public float textureU;
	public float textureV;
	public Vec3D normal;
	public boolean textured;
	
	public NMTTextureVertex(float x, float y, float z, float u, float v)
	{
		this(Vec3D.createVectorHelper(x, y, z), u, v);
	}
	
	public NMTTextureVertex(Vec3D vector, float u, float v)
	{
		this(new NMTVertex(vector), u, v);
	}
	
	public NMTTextureVertex(NMTVertex vert, float u, float v)
	{
		this(vert, u, v, null);
	}
	
	public NMTTextureVertex(NMTVertex vert, float u, float v, Vec3D n)
	{
		vertex = vert;
		textureU = u;
		textureV = v;
		normal = n;
		textured = true;
	}
}
