package com.mvw.trinamegen;

import java.util.ArrayList;

public class Part {
	private String partString;
	private boolean endPart = false;
	private ArrayList<Part> nextPart = new ArrayList<Part>();

	public Part(String partString) {
		this.partString = partString;
	}

	public void canEnd(boolean isEnd) {
		endPart = isEnd;
	}

	public boolean isEnd() {
		return endPart;
	}

	public void addPart(Part part) {
		if(!nextPart.contains(part)) {
			nextPart.add(part);
		}
	}

	public int length() {
		return partString.length();
	}

	public ArrayList<Part> getParts() {
		return new ArrayList<Part>(nextPart);
	}

	public String getString() {
		return partString;
	}
}
