package com.mvw.trinamegen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Random;

public class Dictionary {
	private ArrayList<String> unprocessedNames = new ArrayList<String>();
	private ArrayList<String> processedNames = new ArrayList<String>();
	private ArrayList<String> generatedNames = new ArrayList<String>();
	private ArrayList<Part> startParts = new ArrayList<Part>();
	private HashMap<String, Part> partDictionary = new HashMap<String, Part>();
	
	private boolean debug = false;
	private final int minLength;
	private final int maxLength;
	private final int startMin;
	
	public Dictionary() {
		this.minLength = 2;
		this.maxLength = 3;
		this.startMin = 1;
	}
	
	public Dictionary(Dictionary...dictionaries) {
		addDictionary(dictionaries);
		this.minLength = 2;
		this.maxLength = 3;
		this.startMin = 1;
	}
	
	public Dictionary(int minLength, int maxLength) {
		this.minLength = (minLength <= 0 ? 2 : minLength);
		this.maxLength = (maxLength < this.minLength ? (this.minLength == 2 ? 3 : this.minLength) : maxLength);
		this.startMin = this.minLength - 1;
	}

	public Dictionary(int minLength, int maxLength, int startMin) {
		this.minLength = (minLength <= 0 ? 2 : minLength);
		this.maxLength = (maxLength < this.minLength ? (this.minLength == 2 ? 3 : this.minLength) : maxLength);
		this.startMin = (startMin > 0 ? Math.min(startMin, this.minLength) : this.minLength - 1);
	}
	
	public Dictionary(int minLength, int maxLength, Dictionary...dictionaries) {
		addDictionary(dictionaries);
		this.minLength = (minLength <= 0 ? 2 : minLength);
		this.maxLength = (maxLength < this.minLength ? (this.minLength == 2 ? 3 : this.minLength) : maxLength);
		this.startMin = this.minLength - 1;
	}

	public Dictionary(int minLength, int maxLength, int startMin, Dictionary...dictionaries) {
		addDictionary(dictionaries);
		this.minLength = (minLength <= 0 ? 2 : minLength);
		this.maxLength = (maxLength < this.minLength ? (this.minLength == 2 ? 3 : this.minLength) : maxLength);
		this.startMin = (startMin > 0 ? Math.min(startMin, this.minLength) : this.minLength - 1);
	}
	
	public void addDictionary(Dictionary...dictionaries) {
		ArrayList<String> baseNames = getBaseNames();
		for(Dictionary dictionary : dictionaries) {
			ArrayList<String> dictionaryNames = dictionary.getBaseNames();
			for(String name : dictionaryNames) {
				if(name.isEmpty()) {
					continue;
				}
				if(!baseNames.contains(name)) {
					unprocessedNames.add(name);
					baseNames.add(name);
				}
			}
		}
	}
	
	public void addNames(ArrayList<String> names) {
		ArrayList<String> baseNames = getBaseNames();
		for(String name : names) {
			if(name.isEmpty()) {
				continue;
			}
			if(!baseNames.contains(name)) {
				unprocessedNames.add(name);
				baseNames.add(name);
			}
		}
	}
	
	public ArrayList<String> getBaseNames() {
		ArrayList<String> baseNames = new ArrayList<String>();
		baseNames.addAll(unprocessedNames);
		baseNames.addAll(processedNames);
		return baseNames;
	}
	
	public void processNames() {
		while(unprocessedNames.size() > 0) {
			String name = unprocessedNames.get(0).toLowerCase();
			unprocessedNames.remove(0);
			processName(name);
			processedNames.add(name);
		}
	}
	
	private void processName(String name) {
		processName(name, null);
	}
	
	private void processName(String name, Part previous) {
		ArrayList<Object[]> proc = new ArrayList<Object[]>();
		proc.add(new Object[]{new Integer(Math.min(startMin, name.length())), name, null});
		while(!proc.isEmpty()) {
			while(!proc.isEmpty() && (int)proc.get(proc.size() - 1)[0] > Math.min(((String)proc.get(proc.size() - 1)[1]).length(), maxLength)) {
				proc.remove(proc.size() - 1);
			}
			if(proc.isEmpty()) {
				continue;
			}
			int last = proc.size() - 1;
			Part part;
			String partString = ((String)proc.get(last)[1]).substring(0, (int)proc.get(last)[0]);
			if(partDictionary.containsKey(partString)) {
				part = partDictionary.get(partString);
			} else {
				part = new Part(partString);
				partDictionary.put(partString, part);
			}
			if(proc.get(last)[2] != null) {
				((Part) proc.get(last)[2]).addPart(part);
			} else {
				if(!startParts.contains(part)) {
					startParts.add(part);
				}
			}
			if(((String) proc.get(last)[1]).length() == (int)proc.get(last)[0]) {
				part.canEnd(true);
				Object[] tProc = proc.get(last);
				tProc[0] = (int)tProc[0] + 1;
				proc.set(last, tProc);
			} else {
				String newName = ((String)proc.get(last)[1]).substring(partString.length());
				proc.add(new Object[]{new Integer(Math.min(minLength, newName.length())), newName, part});
				Object[] tProc = proc.get(last);
				tProc[0] = (int)tProc[0] + 1;
				proc.set(last, tProc);
			}
		}
	}
	
	public ArrayList<Part> getParts() {
		return new ArrayList<Part>(partDictionary.values());
	}
	
	public ArrayList<Part> getStartParts() {
		return new ArrayList<Part>(startParts);
	}
	
	public void generateAllNames() {
		generateAllNames(10);
	}
	
	public void generateAllNames(int maxNameLength) {
		generateAllNames(maxNameLength, 3);
	}
	
	public void generateAllNames(int maxNameLength, int minNameLength) {
		generateAllNames(maxNameLength, minNameLength, generatedNames);
	}
	
	public void generateAllNames(int maxNameLength, int minNameLength, ArrayList<String> nameList) {
		if(minNameLength < 2) {
			minNameLength = 3;
		}
		if(maxNameLength < minNameLength) {
			maxNameLength = minNameLength;
		}
		ArrayList<Object[]> proc = new ArrayList<Object[]>();
		Part[] tStart = new Part[startParts.size()];
		startParts.toArray(tStart);
		proc.add(new Object[] {tStart, ""});
		while(!proc.isEmpty()) {
			int last = proc.size() - 1;
			Object[] tProc = proc.get(last);
			Part[] tList = (Part[])tProc[0];
			if(tList.length == 0) {
				proc.remove(last);
				continue;
			}
			ArrayList<Part> list = new ArrayList<Part>(Arrays.asList(tList));
			Part part = list.remove(0);
			tList = new Part[list.size()];
			list.toArray(tList);
			tProc[0] = tList;
			proc.set(last, tProc);
			String name = (String)tProc[1] + part.getString();
			if(name.length() >= minNameLength && name.length() <= maxNameLength && part.isEnd() && !nameList.contains(name)) {
				nameList.add(name);
				if(debug) {
					System.out.println(name);
				}
			}
			if(name.length() >= maxNameLength) {
				continue;
			}
			int index = Math.min(minLength, name.length());
			ArrayList<Part> nextParts = new ArrayList<Part>();
			while(index <= Math.min(maxLength, name.length())) {
				String partString = name.substring(name.length() - index);
				index+= 1;
				if(!partDictionary.containsKey(partString)) {
					continue;
				}
				ArrayList<Part> parts = partDictionary.get(partString).getParts();
				if(parts.isEmpty()) {
					continue;
				}
				for(Part cPart : parts) {
					if((name + cPart.getString()).length() > maxNameLength || nextParts.contains(cPart)) {
						continue;
					}
					nextParts.add(cPart);
				}
			}
			tList = new Part[nextParts.size()];
			nextParts.toArray(tList);
			tProc = new Object[2];
			tProc[0] = tList;
			tProc[1] = name;
			proc.add(tProc);
		}
	}
	
	public ArrayList<String> getGeneratedNames() {
		return new ArrayList<String>(generatedNames);
	}
	
	public String generateName(int maxNameLength) {
		return generateName(maxNameLength, new Random());
	}
	
	public String generateName(int maxNameLength, long seed) {
		return generateName(maxNameLength, new Random(seed));
	}
	
	public String generateName(int maxNameLength, Random rng) {
		return generateName(maxNameLength, 3, rng, generatedNames);
	}

	public String generateName(int maxNameLength, int minNameLength) {
		return generateName(maxNameLength, minNameLength, new Random());
	}
	
	public String generateName(int maxNameLength, int minNameLength, long seed) {
		return generateName(maxNameLength, minNameLength, new Random(seed));
	}
	
	public String generateName(int maxNameLength, int minNameLength, Random rng) {
		return generateName(maxNameLength, minNameLength, rng, generatedNames);
	}
	
	public String generateName(int maxNameLength, int minNameLength, Random rng, ArrayList<String> nameList) {
		if(minNameLength < 2) {
			minNameLength = 3;
		}
		if(maxNameLength < minNameLength) {
			maxNameLength = minNameLength;
		}
		if(rng == null) {
			rng = new Random();
		}
		ArrayList<Object[]> proc = new ArrayList<Object[]>();
		Part[] tStart = new Part[startParts.size()];
		startParts.toArray(tStart);
		proc.add(new Object[] {tStart, ""});
		while(!proc.isEmpty()) {
			int last = proc.size() - 1;
			Object[] tProc = proc.get(last);
			Part[] tList = (Part[])tProc[0];
			if(tList.length == 0) {
				proc.remove(last);
				continue;
			}
			ArrayList<Part> list = new ArrayList<Part>(Arrays.asList(tList));
			int index = rng.nextInt(list.size());
			Part part = list.remove(index);
			tList = new Part[list.size()];
			list.toArray(tList);
			tProc[0] = tList;
			proc.set(last, tProc);
			String name = (String)tProc[1] + part.getString();
			int rndn = rng.nextInt(2);
			if(name.length() >= minNameLength && name.length() <= maxNameLength && part.isEnd() && !nameList.contains(name)) {
				if(rndn == 0) {
					nameList.add(name);
					if(debug) {
						System.out.println(name);
					}
					return name;
				}
				list.add(part);
				tList = new Part[list.size()];
				list.toArray(tList);
				tProc[0] = tList;
				proc.set(last, tProc);
			}
			if(name.length() >= maxNameLength) {
				continue;
			}
			index = Math.min(minLength, name.length());
			ArrayList<Part> nextParts = new ArrayList<Part>();
			while(index <= Math.min(maxLength, name.length())) {
				String partString = name.substring(name.length() - index);
				index+= 1;
				if(!partDictionary.containsKey(partString)) {
					continue;
				}
				ArrayList<Part> parts = partDictionary.get(partString).getParts();
				if(parts.isEmpty()) {
					continue;
				}
				for(Part cPart : parts) {
					if((name + cPart.getString()).length() > maxNameLength || nextParts.contains(cPart)) {
						continue;
					}
					nextParts.add(cPart);
				}
			}
			tList = new Part[nextParts.size()];
			nextParts.toArray(tList);
			tProc = new Object[2];
			tProc[0] = tList;
			tProc[1] = name;
			proc.add(tProc);
		}
		return "";
	}
	
	public void clearGenerated() {
		generatedNames.clear();
	}
	
	public void setDebug(boolean debug) {
		this.debug = debug;
	}
}
