/*
 * Decompiled with CFR 0.152.
 */
package com.mvw.trinamegen;

import com.mvw.trinamegen.Part;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Random;

public class Dictionary {
    private ArrayList<String> unprocessedNames = new ArrayList();
    private ArrayList<String> processedNames = new ArrayList();
    private ArrayList<String> generatedNames = new ArrayList();
    private ArrayList<Part> startParts = new ArrayList();
    private HashMap<String, Part> partDictionary = new HashMap();
    private boolean debug = false;
    private final int minLength;
    private final int maxLength;
    private final int startMin;

    public Dictionary() {
        this.minLength = 2;
        this.maxLength = 3;
        this.startMin = 1;
    }

    public Dictionary(Dictionary ... dictionaries) {
        this.addDictionary(dictionaries);
        this.minLength = 2;
        this.maxLength = 3;
        this.startMin = 1;
    }

    public Dictionary(int minLength, int maxLength) {
        int n = this.minLength = minLength <= 0 ? 2 : minLength;
        this.maxLength = maxLength < this.minLength ? (this.minLength == 2 ? 3 : this.minLength) : maxLength;
        this.startMin = this.minLength - 1;
    }

    public Dictionary(int minLength, int maxLength, int startMin) {
        int n = this.minLength = minLength <= 0 ? 2 : minLength;
        this.maxLength = maxLength < this.minLength ? (this.minLength == 2 ? 3 : this.minLength) : maxLength;
        this.startMin = startMin > 0 ? Math.min(startMin, this.minLength) : this.minLength - 1;
    }

    public Dictionary(int minLength, int maxLength, Dictionary ... dictionaries) {
        this.addDictionary(dictionaries);
        int n = this.minLength = minLength <= 0 ? 2 : minLength;
        this.maxLength = maxLength < this.minLength ? (this.minLength == 2 ? 3 : this.minLength) : maxLength;
        this.startMin = this.minLength - 1;
    }

    public Dictionary(int minLength, int maxLength, int startMin, Dictionary ... dictionaries) {
        this.addDictionary(dictionaries);
        int n = this.minLength = minLength <= 0 ? 2 : minLength;
        this.maxLength = maxLength < this.minLength ? (this.minLength == 2 ? 3 : this.minLength) : maxLength;
        this.startMin = startMin > 0 ? Math.min(startMin, this.minLength) : this.minLength - 1;
    }

    public void addDictionary(Dictionary ... dictionaries) {
        ArrayList<String> baseNames = this.getBaseNames();
        Dictionary[] dictionaryArray = dictionaries;
        int n = dictionaries.length;
        int n2 = 0;
        while (n2 < n) {
            Dictionary dictionary = dictionaryArray[n2];
            ArrayList<String> dictionaryNames = dictionary.getBaseNames();
            for (String name : dictionaryNames) {
                if (name.isEmpty() || baseNames.contains(name)) continue;
                this.unprocessedNames.add(name);
                baseNames.add(name);
            }
            ++n2;
        }
    }

    public void addNames(ArrayList<String> names) {
        ArrayList<String> baseNames = this.getBaseNames();
        for (String name : names) {
            if (name.isEmpty() || baseNames.contains(name)) continue;
            this.unprocessedNames.add(name);
            baseNames.add(name);
        }
    }

    public ArrayList<String> getBaseNames() {
        ArrayList<String> baseNames = new ArrayList<String>();
        baseNames.addAll(this.unprocessedNames);
        baseNames.addAll(this.processedNames);
        return baseNames;
    }

    public void processNames() {
        while (this.unprocessedNames.size() > 0) {
            String name = this.unprocessedNames.get(0).toLowerCase();
            this.unprocessedNames.remove(0);
            this.processName(name);
            this.processedNames.add(name);
        }
    }

    private void processName(String name) {
        this.processName(name, null);
    }

    /*
     * Unable to fully structure code
     */
    private void processName(String name, Part previous) {
        proc = new ArrayList<Object[]>();
        v0 = new Object[3];
        v0[0] = new Integer(Math.min(this.startMin, name.length()));
        v0[1] = name;
        proc.add(v0);
        ** GOTO lbl41
        {
            proc.remove(proc.size() - 1);
            do {
                if (!proc.isEmpty() && (Integer)((Object[])proc.get(proc.size() - 1))[0] > Math.min(((String)((Object[])proc.get(proc.size() - 1))[1]).length(), this.maxLength)) continue block0;
                if (proc.isEmpty()) continue;
                last = proc.size() - 1;
                partString = ((String)((Object[])proc.get(last))[1]).substring(0, (Integer)((Object[])proc.get(last))[0]);
                if (this.partDictionary.containsKey(partString)) {
                    part = this.partDictionary.get(partString);
                } else {
                    part = new Part(partString);
                    this.partDictionary.put(partString, part);
                }
                if (((Object[])proc.get(last))[2] != null) {
                    ((Part)((Object[])proc.get(last))[2]).addPart(part);
                } else if (!this.startParts.contains(part)) {
                    this.startParts.add(part);
                }
                if (((String)((Object[])proc.get(last))[1]).length() == ((Integer)((Object[])proc.get(last))[0]).intValue()) {
                    part.canEnd(true);
                    tProc = (Object[])proc.get(last);
                    tProc[0] = (Integer)tProc[0] + 1;
                    proc.set(last, tProc);
                    continue;
                }
                newName = ((String)((Object[])proc.get(last))[1]).substring(partString.length());
                proc.add(new Object[]{new Integer(Math.min(this.minLength, newName.length())), newName, part});
                tProc = (Object[])proc.get(last);
                tProc[0] = (Integer)tProc[0] + 1;
                proc.set(last, tProc);
lbl41:
                // 4 sources

            } while (!proc.isEmpty());
        }
    }

    public ArrayList<Part> getParts() {
        return new ArrayList<Part>(this.partDictionary.values());
    }

    public ArrayList<Part> getStartParts() {
        return new ArrayList<Part>(this.startParts);
    }

    public void generateAllNames() {
        this.generateAllNames(10);
    }

    public void generateAllNames(int maxNameLength) {
        this.generateAllNames(maxNameLength, 3);
    }

    public void generateAllNames(int maxNameLength, int minNameLength) {
        this.generateAllNames(maxNameLength, minNameLength, this.generatedNames);
    }

    public void generateAllNames(int maxNameLength, int minNameLength, ArrayList<String> nameList) {
        if (minNameLength < 2) {
            minNameLength = 3;
        }
        if (maxNameLength < minNameLength) {
            maxNameLength = minNameLength;
        }
        ArrayList<Object[]> proc = new ArrayList<Object[]>();
        Part[] tStart = new Part[this.startParts.size()];
        this.startParts.toArray(tStart);
        proc.add(new Object[]{tStart, ""});
        while (!proc.isEmpty()) {
            int last = proc.size() - 1;
            Object[] tProc = (Object[])proc.get(last);
            Part[] tList = (Part[])tProc[0];
            if (tList.length == 0) {
                proc.remove(last);
                continue;
            }
            ArrayList<Part> list = new ArrayList<Part>(Arrays.asList(tList));
            Part part = list.remove(0);
            tList = new Part[list.size()];
            list.toArray(tList);
            tProc[0] = tList;
            proc.set(last, tProc);
            String name = String.valueOf((String)tProc[1]) + part.getString();
            if (name.length() >= minNameLength && name.length() <= maxNameLength && part.isEnd() && !nameList.contains(name)) {
                nameList.add(name);
                if (this.debug) {
                    System.out.println(name);
                }
            }
            if (name.length() >= maxNameLength) continue;
            int index = Math.min(this.minLength, name.length());
            ArrayList<Part> nextParts = new ArrayList<Part>();
            while (index <= Math.min(this.maxLength, name.length())) {
                ArrayList<Part> parts;
                String partString = name.substring(name.length() - index);
                ++index;
                if (!this.partDictionary.containsKey(partString) || (parts = this.partDictionary.get(partString).getParts()).isEmpty()) continue;
                for (Part cPart : parts) {
                    if ((String.valueOf(name) + cPart.getString()).length() > maxNameLength || nextParts.contains(cPart)) continue;
                    nextParts.add(cPart);
                }
            }
            tList = new Part[nextParts.size()];
            nextParts.toArray(tList);
            tProc = new Object[]{tList, name};
            proc.add(tProc);
        }
    }

    public ArrayList<String> getGeneratedNames() {
        return new ArrayList<String>(this.generatedNames);
    }

    public String generateName(int maxNameLength) {
        return this.generateName(maxNameLength, new Random());
    }

    public String generateName(int maxNameLength, long seed) {
        return this.generateName(maxNameLength, new Random(seed));
    }

    public String generateName(int maxNameLength, Random rng) {
        return this.generateName(maxNameLength, 3, rng, this.generatedNames);
    }

    public String generateName(int maxNameLength, int minNameLength) {
        return this.generateName(maxNameLength, minNameLength, new Random());
    }

    public String generateName(int maxNameLength, int minNameLength, long seed) {
        return this.generateName(maxNameLength, minNameLength, new Random(seed));
    }

    public String generateName(int maxNameLength, int minNameLength, Random rng) {
        return this.generateName(maxNameLength, minNameLength, rng, this.generatedNames);
    }

    public String generateName(int maxNameLength, int minNameLength, Random rng, ArrayList<String> nameList) {
        if (minNameLength < 2) {
            minNameLength = 3;
        }
        if (maxNameLength < minNameLength) {
            maxNameLength = minNameLength;
        }
        if (rng == null) {
            rng = new Random();
        }
        ArrayList<Object[]> proc = new ArrayList<Object[]>();
        Part[] tStart = new Part[this.startParts.size()];
        this.startParts.toArray(tStart);
        proc.add(new Object[]{tStart, ""});
        while (!proc.isEmpty()) {
            int last = proc.size() - 1;
            Object[] tProc = (Object[])proc.get(last);
            Part[] tList = (Part[])tProc[0];
            if (tList.length == 0) {
                proc.remove(last);
                continue;
            }
            ArrayList<Part> list = new ArrayList<Part>(Arrays.asList(tList));
            int index = rng.nextInt(list.size());
            Part part = list.remove(index);
            tList = new Part[list.size()];
            list.toArray(tList);
            tProc[0] = tList;
            proc.set(last, tProc);
            String name = String.valueOf((String)tProc[1]) + part.getString();
            int rndn = rng.nextInt(2);
            if (name.length() >= minNameLength && name.length() <= maxNameLength && part.isEnd() && !nameList.contains(name)) {
                if (rndn == 0) {
                    nameList.add(name);
                    if (this.debug) {
                        System.out.println(name);
                    }
                    return name;
                }
                list.add(part);
                tList = new Part[list.size()];
                list.toArray(tList);
                tProc[0] = tList;
                proc.set(last, tProc);
            }
            if (name.length() >= maxNameLength) continue;
            index = Math.min(this.minLength, name.length());
            ArrayList<Part> nextParts = new ArrayList<Part>();
            while (index <= Math.min(this.maxLength, name.length())) {
                ArrayList<Part> parts;
                String partString = name.substring(name.length() - index);
                ++index;
                if (!this.partDictionary.containsKey(partString) || (parts = this.partDictionary.get(partString).getParts()).isEmpty()) continue;
                for (Part cPart : parts) {
                    if ((String.valueOf(name) + cPart.getString()).length() > maxNameLength || nextParts.contains(cPart)) continue;
                    nextParts.add(cPart);
                }
            }
            tList = new Part[nextParts.size()];
            nextParts.toArray(tList);
            tProc = new Object[]{tList, name};
            proc.add(tProc);
        }
        return "";
    }

    public void clearGenerated() {
        this.generatedNames.clear();
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }
}

