package net.mvw.namegenerator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class NamePart
{
	public NamePart(String strPart)
	{
		part = strPart;
		flags = 0;
		nextParts = new ArrayList<NamePart>();
		partWeight = new HashMap<NamePart, Integer>();
	}
	
	public void addFlag(int flag)
	{
		flags |= flag;
	}
	
	public void addPart(NamePart namePart)
	{
		if(!nextParts.contains(namePart))
			nextParts.add(namePart);
		if(!partWeight.containsKey(namePart))
			partWeight.put(namePart, 0);
		partWeight.put(namePart, partWeight.get(namePart) + 1);
		totalWeight++;
	}
	
	public String getPart()
	{
		return part;
	}
	
	public String generateName()
	{
		return generateName(0);
	}
	
	public String generateName(boolean useWeight)
	{
		return generateName(0, useWeight);
	}
	
	public String generateName(boolean useWeight, int minLength, int maxLength)
	{
		return generateName(0, useWeight, minLength, maxLength);
	}
	
	public boolean hasFlag(int flag)
	{
		return ((flags & flag) > 0);
	}
	
	protected String generateName(int length)
	{
		return generateName(length, false);
	}
	
	protected String generateName(int length, boolean useWeight)
	{
		return generateName(length, useWeight, 3, 20);
	}
	
	protected String generateName(int length, boolean useWeight, int minLength, int maxLength)
	{
		//System.out.println(length + " " + part);
		boolean notEmpty = nextParts.size() > 0;
		boolean isBegin = (length == 0 && !hasFlag(NAME_ISSTANDALONE));
		boolean isEnd = hasFlag(NAME_ISEND);
		boolean randomize = length < NameGenerator.rand.nextInt(maxLength - minLength) + minLength;//NameGenerator.rand.nextInt(2 + length) < 2;
		if(notEmpty && (isBegin || !isEnd || randomize))
		{
			int nextId;
			if(!useWeight)
			{
				nextId = NameGenerator.rand.nextInt(nextParts.size());
			}
			else
			{
				nextId = NameGenerator.rand.nextInt(totalWeight);
				int pickWeight = 0;
				Iterator<NamePart> namePartItr = partWeight.keySet().iterator();
				while(namePartItr.hasNext())
				{
					NamePart curPart = namePartItr.next();
					pickWeight+= partWeight.get(curPart);
					if(nextId < pickWeight)
					{
						nextId = nextParts.indexOf(curPart);
					}
				}
			}
			return part + nextParts.get(nextId).generateName(length + part.length(), useWeight);
		}
		return part;
	}
	
	public boolean hasParts()
	{
		return (nextParts.size() > 0);
	}
	
	public int getTotalParts()
	{
		return nextParts.size();
	}
	
	public int getTotalWeight()
	{
		return totalWeight;
	}

	private String part;
	private int flags;
	private ArrayList<NamePart> nextParts;
	private HashMap<NamePart, Integer> partWeight;
	private int totalWeight;
	
	public static final int NAME_ISBEGIN = 0x1;
	public static final int NAME_ISMIDDLE = 0x2; 
	public static final int NAME_ISEND = 0x4;
	public static final int NAME_ISSTANDALONE = 0x8;
}
