package net.mvw.namegenerator;

import java.util.ArrayList;
import java.util.Arrays;

public class NameList
{
	public NameList()
	{
		uncompiledList = new ArrayList<String>();
		compiledList = new ArrayList<String>();
		parts = new ArrayList<NamePart>();
		startParts = new ArrayList<NamePart>();
		wordBreak = new ArrayList<String>();
		wordBreak.add("");
		wordBreak.add(" ");
		wordBreak.add("-");
	}
	
	public ArrayList<String> getList()
	{
		ArrayList<String> completeList = new ArrayList<String>();
		completeList.addAll(uncompiledList);
		completeList.addAll(compiledList);
		return completeList;
	}
	
	public void addName(String name)
	{
		if(!uncompiledList.contains(name.toLowerCase()) && !compiledList.contains(name.toLowerCase()))
			uncompiledList.add(name.toLowerCase());
	}
	
	public void addName(ArrayList<String> names)
	{
		for(int idx = 0; idx < names.size(); idx++)
		{
			addName(names.get(idx));
		}
	}
	
	public NamePart addPart(String part, int type)
	{
		NamePart currentPart = null;
		for(int idx = 0; idx < parts.size(); idx++)
		{
			if(parts.get(idx).getPart().equals(part))
			{
				currentPart = parts.get(idx);
				break;
			}
		}
		
		if(currentPart == null)
		{
			currentPart = new NamePart(part);
			parts.add(currentPart);
		}
		
		switch(type)
		{
		case NAME_MIDDLE:
			currentPart.addFlag(NamePart.NAME_ISMIDDLE);
			break;
		case NAME_END:
			currentPart.addFlag(NamePart.NAME_ISEND);
			break;
		case NAME_STANDALONE:
			currentPart.addFlag(NamePart.NAME_ISEND | NamePart.NAME_ISSTANDALONE);
		case NAME_BEGIN:
			currentPart.addFlag(NamePart.NAME_ISBEGIN);
			break;
		}
		
		if((type == NAME_BEGIN || type == NAME_STANDALONE) && !startParts.contains(currentPart))
			startParts.add(currentPart);
		
		return currentPart;
	}
	
	public void compileList()
	{
		int partInWord = 0;
		String splitChar = ",";
		while(uncompiledList.size() > 0)
		{
			String name = uncompiledList.get(0).toLowerCase();
			
			uncompiledList.remove(uncompiledList.get(0));
			compiledList.add(name);
			
			if(name.startsWith("$"))
			{
				if(name.toLowerCase().startsWith("$wordbreak "))
				{
					String[] wb = name.split(" ");
					for(int idx = 1; idx < wb.length; idx++)
					{
						if(!wb[idx].equals("") && !wordBreak.contains(wb[idx]))
						{
							wordBreak.add(wb[idx]);
						}
					}
				}
				else if(name.toLowerCase().startsWith("$clwordbreak") && name.toLowerCase().endsWith("$clwordbreak"))
				{
					wordBreak.clear();
					wordBreak.add("");
					wordBreak.add(" ");
					wordBreak.add("-");
				}
				else if(name.toLowerCase().startsWith("$break "))
				{
					String[] sStr = name.split(" ");
					if(sStr[1].equals("char"))
					{
						splitChar = sStr[2];
					}
				}
				continue;
			}
			
			String[] nameParts = name.split(splitChar);
			
			if(nameParts.length == 1)
			{
				addPart(name, NAME_STANDALONE);
				continue;
			}
			
			NamePart oldPart = null;
			NamePart currentPart = null;
			
			for(int idx = 0; idx < nameParts.length; idx++)
			{
				oldPart = currentPart;
				if(partInWord == 0 && !wordBreak.contains(nameParts[idx]) && wordBreak.contains(nameParts[idx + 1]))
					currentPart = addPart(nameParts[idx], NAME_STANDALONE);
				else if(partInWord == 0 && !wordBreak.contains(nameParts[idx]))
					currentPart = addPart(nameParts[idx], NAME_BEGIN);
				else if(idx < nameParts.length - 1 && !wordBreak.contains(nameParts[idx + 1]))
					currentPart = addPart(nameParts[idx], NAME_MIDDLE);
				else
				{
					currentPart = addPart(nameParts[idx], NAME_END);
					partInWord = -1;
				}
				
				partInWord++;
				
				if(oldPart != null)
					oldPart.addPart(currentPart);
			}
			partInWord = 0;
		}
	}
	
	public String generateName()
	{
		return generateName(false);
	}
	
	public String generateName(boolean useWeight)
	{
		return generateName(useWeight, 3, 20);
	}
	
	public String generateName(boolean useWeight, int minLength, int maxLength)
	{
		return startParts.get(NameGenerator.rand.nextInt(startParts.size())).generateName(useWeight, minLength, maxLength);
	}
	
	public String[] generateNames(int amount)
	{
		return generateNames(amount, false);
	}
	
	public String[] generateNames(int amount, boolean useWeight)
	{
		return generateNames(amount, useWeight, 3, 20);
	}
	
	public String[] generateNames(int amount, boolean useWeight, int minLength, int maxLength)
	{
		ArrayList<String> nameList = new ArrayList<String>();
		
		String[] nameArray = new String[amount];
		
		int repeat = 0;
		
		int idx = 0;
		for(int itr = 0; itr < amount; itr++)
		{
			String name = generateName(useWeight, minLength, maxLength);
			if(nameList.contains(name))
			{
				repeat++;
				if(repeat < compiledList.size())
				{
					itr--;
				}
				continue;
			}
			repeat = 0;
			nameList.add(name);
			nameArray[idx] = name;
			idx++;
		}
		nameArray = Arrays.copyOf(nameArray, idx);
		return nameArray;
	}
	
	public int getReferenceSize()
	{
		return uncompiledList.size() + compiledList.size();
	}
	
	public int getDictionarySize()
	{
		return parts.size();
	}
	
	public String listPartsToString()
	{
		String output = "";
		for(int idx = 0; idx < parts.size(); idx++)
		{
			NamePart part = parts.get(idx);
			output += idx + ": " + part.getPart() + " (" + part.getTotalParts() + "/" + part.getTotalWeight() + ")";
			boolean isBegin = part.hasFlag(NamePart.NAME_ISBEGIN);
			boolean isMiddle = part.hasFlag(NamePart.NAME_ISMIDDLE);
			boolean isEnd = part.hasFlag(NamePart.NAME_ISEND);
			boolean isStandAlone = part.hasFlag(NamePart.NAME_ISSTANDALONE);
			if(isBegin)
			{
				output+= " BEGIN";
			}
			if(isMiddle)
			{
				output+= " MIDDLE";
			}
			if(isEnd)
			{
				output+= " END";
			}
			if(isStandAlone)
			{
				output+= " STANDALONE";
			}
			output+= newline;
		}
		return output;
	}
	
	protected ArrayList<String> uncompiledList;
	protected ArrayList<String> compiledList;
	
	protected ArrayList<NamePart> parts;
	protected ArrayList<NamePart> startParts;
	
	protected ArrayList<String> wordBreak;

	protected static final int NAME_BEGIN = 0;
	protected static final int NAME_MIDDLE = 1;
	protected static final int NAME_END = 2;
	protected static final int NAME_STANDALONE = 3;
	
	public static String newline = System.getProperty("line.separator");
}
