package net.mvw.namegenerator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import java.util.HashMap;
import java.io.File;
import java.io.BufferedReader;
import java.io.FileReader;

public class NameGenerator
{
	public static void setSeed(int seed)
	{
		rand = new Random(seed);
	}
	
	public static void readFile(String fileName) throws Throwable
	{
		String name = "";
		if(fileName.indexOf(",") > -1)
		{
			String[] names = fileName.split(",");
			for(int idx = 0; idx < names.length; idx++)
			{
				if(names[idx].lastIndexOf(".txt") > 0)
				{
					names[idx] = names[idx].substring(0, names[idx].lastIndexOf(".txt"));
				}
				if(idx > 0)
				{
					name+= ",";
				}
				name+= names[idx];
			}
		}
		else
		{
			name = fileName;
			if(name.lastIndexOf(".txt") > 0)
			{
				name = name.substring(0, name.lastIndexOf(".txt"));
			}
		}
		readFile(fileName, name);
	}
	
	public static void readFile(String fileName, String groupName) throws Throwable
	{
		if(fileName.indexOf(",") > -1)
		{
			readFile(fileName.split(","), groupName);
		}
		else
		{
			readFile(new File(fileName), groupName);
		}
	}
	
	public static void readFile(String[] fileNames, String groupName) throws Throwable
	{
		for(int idx = 0; idx < fileNames.length; idx++)
		{
			readFile(new File(fileNames[idx]), groupName);
		}
	}
	
	public static void readFile(File file) throws Throwable
	{
		String name = file.getName();
		if(name.lastIndexOf(".txt") > 0)
			name = name.substring(0, name.lastIndexOf(".txt"));
		readFile(file, name);
	}
	
	public static void readFile(File file, String groupName) throws Throwable
	{
		NameList nameList = loadNameList(groupName);
		
		BufferedReader in = new BufferedReader(new FileReader(file));
		
		String s;
		
		while((s = in.readLine()) != null)
		{
			if(s.indexOf("#") > -1)
			{
				s = s.substring(0, s.indexOf("#"));
			}
			
			s = s.trim();
			
			if(s.equals(""))
			{
				continue;
			}
			
			nameList.addName(s);
		}
		
		nameList.compileList();
		
	}

	protected static NameList loadNameList(String groupName)
	{
		if(nameMap.containsKey(groupName))
			return nameMap.get(groupName);
		NameList nameList = new NameList();
		nameMap.put(groupName, nameList);
		return nameList;
	}

	public static void readFolder(File folder) throws Throwable
	{
		if(!folder.isDirectory())
			throw new IllegalArgumentException("Not a directory");
		
		File[] folderList = folder.listFiles();
		
		for(int idx = 0; idx < folderList.length; idx++)
		{
			if(!folderList[idx].isDirectory())
				readFile(folderList[idx]);
		}
	}
	
	public static String generateName(String nameList)
	{
		return generateName(nameList, false);
	}
	
	public static String generateName(String nameList, boolean useWeight)
	{
		if(!nameMap.containsKey(nameList))
			return "";
		return nameMap.get(nameList).generateName(useWeight);
	}
	
	public static String[] generateNames(String nameList, int amount)
	{
		return generateNames(nameList, amount, false);
	}
	
	public static String[] generateNames(String nameList, int amount, boolean useWeight)
	{
		return generateNames(nameList, amount, useWeight, 3, 20);
	}
	
	public static String[] generateNames(String nameList, int amount, boolean useWeight, int minLength, int maxLength)
	{
		if(!nameMap.containsKey(nameList))
			return new String[] {""};
		return nameMap.get(nameList).generateNames(amount, useWeight, minLength, maxLength);
	}
	
	public static void removeList(String nameList)
	{
		if(nameMap.containsKey(nameList))
			nameMap.remove(nameList);
	}
	
	public static int getReferenceSize(String nameList)
	{
		if(!nameMap.containsKey(nameList))
		{
			return 0;
		}
		return nameMap.get(nameList).getReferenceSize();
	}

	public static int getDictionarySize(String nameList)
	{
		if(!nameMap.containsKey(nameList))
		{
			return 0;
		}
		return nameMap.get(nameList).getDictionarySize();
	}
	
	public static String listPartsToString(String nameList)
	{
		if(!nameMap.containsKey(nameList))
		{
			return "";
		}
		return nameMap.get(nameList).listPartsToString();
	}
	
	public static String getReferenceNames(String nameList)
	{
		if(!nameMap.containsKey(nameList))
		{
			return "";
		}
		
		ArrayList<String> list = nameMap.get(nameList).getList();
		String splitChar = ",";
		for(int idx = 0; idx < list.size(); idx++)
		{
			if(list.get(idx).startsWith("$break char "))
			{
				splitChar = (list.get(idx).split(" "))[2];
				continue;
			}
			list.set(idx, list.get(idx).replaceAll(splitChar, ""));
		}
		Collections.sort(list);
		
		String returnString = "";
		
		for(int idx = 0; idx < list.size(); idx++)
		{
			if(!list.get(idx).startsWith("$"))
			{
				returnString += list.get(idx) + newline;
			}
		}
		
		return returnString;
	}

	public static Random rand = new Random();
	
	private static final HashMap<String, NameList> nameMap = new HashMap<String, NameList>();
	public static String newline = System.getProperty("line.separator");
}
