import net.mvw.namegenerator.*;
import java.util.Arrays;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

public class NameGenMain extends JFrame implements ActionListener, ItemListener
{
	/**
	 * 
	 */
	private static final long serialVersionUID = 266394613580695406L;

	public NameGenMain()
	{
		super("Name Generator");
	}
	
	protected JMenuBar createMenu()
	{
		JMenuBar menuBar = new JMenuBar();
		JMenu fileMenu = new JMenu("File");

		fileMenu.setMnemonic(KeyEvent.VK_F);
		
		menuBar.add(fileMenu);
		
		JMenuItem closeItem = new JMenuItem("Close", KeyEvent.VK_C);
		closeItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_F4, ActionEvent.ALT_MASK));
		closeItem.setActionCommand("close");
		closeItem.addActionListener(this);
		
		fileMenu.add(closeItem);
		
		return menuBar;
	}
	
	protected Container createContent(Container container)
	{
		
		return container;
	}

	/**
	 * @param args
	 */
	public static void main(String[] args)
	{
		try
		{
			if(args.length == 0)
			{
				System.out.println("Usage:");
				System.out.println("java -jar namegen.jar <filename[|filename2|...|filenameN]> [listname] [amount] [(lengthmin-lengthmax)] [UNWEIGHTED]");
				return;
			}
			String file = args[0];
			String name = file;
			if(args.length >= 2)
			{
				name = args[1];
			}
			
			int amount = 5;
			
			if(args.length >= 3)
			{
				amount = Integer.parseInt(args[2]);
			}
			
			int min = 3;
			int max = 17;
			
			if(args.length >= 4 && args[3].startsWith("(") && args[3].endsWith(")"))
			{
				String[] str = args[3].substring(1, args[3].lastIndexOf(")")).split(",");
				if(str.length >= 2)
				{
					min = Integer.parseInt(str[0]);
					max = Integer.parseInt(str[1]);
				}
			}
			
			boolean weighted = true;
			
			if(args.length >= 5 && args[4].toLowerCase().equals("unweighted"))
			{
				weighted = false;
			}
			
			System.out.println("==================");
			System.out.println("= NAME GENERATOR =");
			System.out.println("==================");
			System.out.println("");
			if(file.indexOf(",") > -1)
			{
				System.out.print("Reading files ");
				String[] files = file.split(",");
				for(int idx = 0; idx < files.length; idx++)
				{
					if(idx == files.length - 1)
					{
						System.out.print(" and ");
					}
					else if(idx > 0)
					{
						System.out.print(", ");
					}
					System.out.print(files[idx]);
				}
				System.out.println(".");
			}
			else
			{
				System.out.println("Reading file " + file + ".");
			}
			NameGenerator.readFile(file, name);
			System.out.println("Loaded " + NameGenerator.getReferenceSize(name) + " names.");
			System.out.println("Dictionary contains " + NameGenerator.getDictionarySize(name) + " entries.");
			if(args.length >= 6 && args[5].equals("DEBUG"))
			{
				System.out.println("");
				System.out.println("Reference names");
				System.out.println("---------------");
				System.out.println(NameGenerator.getReferenceNames(name));
				System.out.println("");
				System.out.println("Name parts");
				System.out.println("----------");
				System.out.println(NameGenerator.listPartsToString(name));
			}
			System.out.println("");
			System.out.println("Generating " + amount + " names, using " + (weighted ? "weighted" : "unweighted") + " chances.");
			String[] test = NameGenerator.generateNames(name, amount, weighted, min, max);
			if(test.length < amount)
			{
				System.out.println("Could only generate " + test.length + " names.");
			}
			System.out.println("");
			System.out.println("Sorting name list.");
			Arrays.sort(test);
			System.out.println("");
			for(int idx = 0; idx < test.length; idx++)
			{
				System.out.println(test[idx]);
			}
			System.out.println("");
			System.out.println("Done.");
			System.out.println("");
		}
		catch(Throwable t)
		{
			t.printStackTrace();
		}
		/*
		NameGenMain frame = new NameGenMain();
		
		JMenuBar menuBar = frame.createMenu();
		
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		
		Container container = frame.createContent(frame.getContentPane());
		
		frame.setSize(550, 400);
		
		frame.setJMenuBar(menuBar);
		
		frame.setVisible(true);*/
	}

	@Override
	public void itemStateChanged(ItemEvent e)
	{
		// TODO Auto-generated method stub
		
	}

	@Override
	public void actionPerformed(ActionEvent e)
	{
		// TODO Auto-generated method stub
		if("close".equals(e.getActionCommand()))
		{
			System.exit(0);
		}
	}
}
