/*
 * Decompiled with CFR 0.152.
 */
package net.mvw.namegenerator;

import java.util.ArrayList;
import java.util.HashMap;
import net.mvw.namegenerator.NameGenerator;

public class NamePart {
    private String part;
    private int flags;
    private ArrayList<NamePart> nextParts;
    private HashMap<NamePart, Integer> partWeight;
    private int totalWeight;
    public static final int NAME_ISBEGIN = 1;
    public static final int NAME_ISMIDDLE = 2;
    public static final int NAME_ISEND = 4;
    public static final int NAME_ISSTANDALONE = 8;

    public NamePart(String strPart) {
        this.part = strPart;
        this.flags = 0;
        this.nextParts = new ArrayList();
        this.partWeight = new HashMap();
    }

    public void addFlag(int flag) {
        this.flags |= flag;
    }

    public void addPart(NamePart namePart) {
        if (!this.nextParts.contains(namePart)) {
            this.nextParts.add(namePart);
        }
        if (!this.partWeight.containsKey(namePart)) {
            this.partWeight.put(namePart, 0);
        }
        this.partWeight.put(namePart, this.partWeight.get(namePart) + 1);
        ++this.totalWeight;
    }

    public String getPart() {
        return this.part;
    }

    public String generateName() {
        return this.generateName(0);
    }

    public String generateName(boolean useWeight) {
        return this.generateName(0, useWeight);
    }

    public String generateName(boolean useWeight, int minLength, int maxLength) {
        return this.generateName(0, useWeight, minLength, maxLength);
    }

    public boolean hasFlag(int flag) {
        return (this.flags & flag) > 0;
    }

    protected String generateName(int length) {
        return this.generateName(length, false);
    }

    protected String generateName(int length, boolean useWeight) {
        return this.generateName(length, useWeight, 3, 20);
    }

    protected String generateName(int length, boolean useWeight, int minLength, int maxLength) {
        boolean randomize;
        boolean notEmpty = this.nextParts.size() > 0;
        boolean isBegin = length == 0 && !this.hasFlag(8);
        boolean isEnd = this.hasFlag(4);
        boolean bl = randomize = length < NameGenerator.rand.nextInt(maxLength - minLength) + minLength;
        if (notEmpty && (isBegin || !isEnd || randomize)) {
            int nextId;
            if (!useWeight) {
                nextId = NameGenerator.rand.nextInt(this.nextParts.size());
            } else {
                nextId = NameGenerator.rand.nextInt(this.totalWeight);
                int pickWeight = 0;
                for (NamePart curPart : this.partWeight.keySet()) {
                    if (nextId >= (pickWeight += this.partWeight.get(curPart).intValue())) continue;
                    nextId = this.nextParts.indexOf(curPart);
                }
            }
            return String.valueOf(this.part) + this.nextParts.get(nextId).generateName(length + this.part.length(), useWeight);
        }
        return this.part;
    }

    public boolean hasParts() {
        return this.nextParts.size() > 0;
    }

    public int getTotalParts() {
        return this.nextParts.size();
    }

    public int getTotalWeight() {
        return this.totalWeight;
    }
}

