/*
 * Decompiled with CFR 0.152.
 */
package net.mvw.namegenerator;

import java.util.ArrayList;
import java.util.Arrays;
import net.mvw.namegenerator.NameGenerator;
import net.mvw.namegenerator.NamePart;

public class NameList {
    protected ArrayList<String> uncompiledList = new ArrayList();
    protected ArrayList<String> compiledList = new ArrayList();
    protected ArrayList<NamePart> parts = new ArrayList();
    protected ArrayList<NamePart> startParts = new ArrayList();
    protected ArrayList<String> wordBreak = new ArrayList();
    protected static final int NAME_BEGIN = 0;
    protected static final int NAME_MIDDLE = 1;
    protected static final int NAME_END = 2;
    protected static final int NAME_STANDALONE = 3;
    public static String newline = System.getProperty("line.separator");

    public NameList() {
        this.wordBreak.add("");
        this.wordBreak.add(" ");
        this.wordBreak.add("-");
    }

    public ArrayList<String> getList() {
        ArrayList<String> completeList = new ArrayList<String>();
        completeList.addAll(this.uncompiledList);
        completeList.addAll(this.compiledList);
        return completeList;
    }

    public void addName(String name) {
        if (!this.uncompiledList.contains(name.toLowerCase()) && !this.compiledList.contains(name.toLowerCase())) {
            this.uncompiledList.add(name.toLowerCase());
        }
    }

    public void addName(ArrayList<String> names) {
        int idx = 0;
        while (idx < names.size()) {
            this.addName(names.get(idx));
            ++idx;
        }
    }

    public NamePart addPart(String part, int type) {
        NamePart currentPart = null;
        int idx = 0;
        while (idx < this.parts.size()) {
            if (this.parts.get(idx).getPart().equals(part)) {
                currentPart = this.parts.get(idx);
                break;
            }
            ++idx;
        }
        if (currentPart == null) {
            currentPart = new NamePart(part);
            this.parts.add(currentPart);
        }
        switch (type) {
            case 1: {
                currentPart.addFlag(2);
                break;
            }
            case 2: {
                currentPart.addFlag(4);
                break;
            }
            case 3: {
                currentPart.addFlag(12);
            }
            case 0: {
                currentPart.addFlag(1);
            }
        }
        if (!(type != 0 && type != 3 || this.startParts.contains(currentPart))) {
            this.startParts.add(currentPart);
        }
        return currentPart;
    }

    public void compileList() {
        int partInWord = 0;
        String splitChar = ",";
        while (this.uncompiledList.size() > 0) {
            String name = this.uncompiledList.get(0).toLowerCase();
            this.uncompiledList.remove(this.uncompiledList.get(0));
            this.compiledList.add(name);
            if (name.startsWith("$")) {
                String[] sStr;
                if (name.toLowerCase().startsWith("$wordbreak ")) {
                    String[] wb = name.split(" ");
                    int idx = 1;
                    while (idx < wb.length) {
                        if (!wb[idx].equals("") && !this.wordBreak.contains(wb[idx])) {
                            this.wordBreak.add(wb[idx]);
                        }
                        ++idx;
                    }
                    continue;
                }
                if (name.toLowerCase().startsWith("$clwordbreak") && name.toLowerCase().endsWith("$clwordbreak")) {
                    this.wordBreak.clear();
                    this.wordBreak.add("");
                    this.wordBreak.add(" ");
                    this.wordBreak.add("-");
                    continue;
                }
                if (!name.toLowerCase().startsWith("$break ") || !(sStr = name.split(" "))[1].equals("char")) continue;
                splitChar = sStr[2];
                continue;
            }
            String[] nameParts = name.split(splitChar);
            if (nameParts.length == 1) {
                this.addPart(name, 3);
                continue;
            }
            NamePart oldPart = null;
            NamePart currentPart = null;
            int idx = 0;
            while (idx < nameParts.length) {
                oldPart = currentPart;
                if (partInWord == 0 && !this.wordBreak.contains(nameParts[idx]) && this.wordBreak.contains(nameParts[idx + 1])) {
                    currentPart = this.addPart(nameParts[idx], 3);
                } else if (partInWord == 0 && !this.wordBreak.contains(nameParts[idx])) {
                    currentPart = this.addPart(nameParts[idx], 0);
                } else if (idx < nameParts.length - 1 && !this.wordBreak.contains(nameParts[idx + 1])) {
                    currentPart = this.addPart(nameParts[idx], 1);
                } else {
                    currentPart = this.addPart(nameParts[idx], 2);
                    partInWord = -1;
                }
                ++partInWord;
                if (oldPart != null) {
                    oldPart.addPart(currentPart);
                }
                ++idx;
            }
            partInWord = 0;
        }
    }

    public String generateName() {
        return this.generateName(false);
    }

    public String generateName(boolean useWeight) {
        return this.generateName(useWeight, 3, 20);
    }

    public String generateName(boolean useWeight, int minLength, int maxLength) {
        return this.startParts.get(NameGenerator.rand.nextInt(this.startParts.size())).generateName(useWeight, minLength, maxLength);
    }

    public String[] generateNames(int amount) {
        return this.generateNames(amount, false);
    }

    public String[] generateNames(int amount, boolean useWeight) {
        return this.generateNames(amount, useWeight, 3, 20);
    }

    public String[] generateNames(int amount, boolean useWeight, int minLength, int maxLength) {
        ArrayList<String> nameList = new ArrayList<String>();
        String[] nameArray = new String[amount];
        int repeat = 0;
        int idx = 0;
        int itr = 0;
        while (itr < amount) {
            String name = this.generateName(useWeight, minLength, maxLength);
            if (nameList.contains(name)) {
                if (++repeat < this.compiledList.size()) {
                    --itr;
                }
            } else {
                repeat = 0;
                nameList.add(name);
                nameArray[idx] = name;
                ++idx;
            }
            ++itr;
        }
        nameArray = Arrays.copyOf(nameArray, idx);
        return nameArray;
    }

    public int getReferenceSize() {
        return this.uncompiledList.size() + this.compiledList.size();
    }

    public int getDictionarySize() {
        return this.parts.size();
    }

    public String listPartsToString() {
        String output = "";
        int idx = 0;
        while (idx < this.parts.size()) {
            NamePart part = this.parts.get(idx);
            output = String.valueOf(output) + idx + ": " + part.getPart() + " (" + part.getTotalParts() + "/" + part.getTotalWeight() + ")";
            boolean isBegin = part.hasFlag(1);
            boolean isMiddle = part.hasFlag(2);
            boolean isEnd = part.hasFlag(4);
            boolean isStandAlone = part.hasFlag(8);
            if (isBegin) {
                output = String.valueOf(output) + " BEGIN";
            }
            if (isMiddle) {
                output = String.valueOf(output) + " MIDDLE";
            }
            if (isEnd) {
                output = String.valueOf(output) + " END";
            }
            if (isStandAlone) {
                output = String.valueOf(output) + " STANDALONE";
            }
            output = String.valueOf(output) + newline;
            ++idx;
        }
        return output;
    }
}

