/*
 * Decompiled with CFR 0.152.
 */
package net.mvw.namegenerator;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Random;
import net.mvw.namegenerator.NameList;

public class NameGenerator {
    public static Random rand = new Random();
    private static final HashMap<String, NameList> nameMap = new HashMap();
    public static String newline = System.getProperty("line.separator");

    public static void setSeed(int seed) {
        rand = new Random(seed);
    }

    public static void readFile(String fileName) throws Throwable {
        String name = "";
        if (fileName.indexOf(",") > -1) {
            String[] names = fileName.split(",");
            int idx = 0;
            while (idx < names.length) {
                if (names[idx].lastIndexOf(".txt") > 0) {
                    names[idx] = names[idx].substring(0, names[idx].lastIndexOf(".txt"));
                }
                if (idx > 0) {
                    name = String.valueOf(name) + ",";
                }
                name = String.valueOf(name) + names[idx];
                ++idx;
            }
        } else {
            name = fileName;
            if (name.lastIndexOf(".txt") > 0) {
                name = name.substring(0, name.lastIndexOf(".txt"));
            }
        }
        NameGenerator.readFile(fileName, name);
    }

    public static void readFile(String fileName, String groupName) throws Throwable {
        if (fileName.indexOf(",") > -1) {
            NameGenerator.readFile(fileName.split(","), groupName);
        } else {
            NameGenerator.readFile(new File(fileName), groupName);
        }
    }

    public static void readFile(String[] fileNames, String groupName) throws Throwable {
        int idx = 0;
        while (idx < fileNames.length) {
            NameGenerator.readFile(new File(fileNames[idx]), groupName);
            ++idx;
        }
    }

    public static void readFile(File file) throws Throwable {
        String name = file.getName();
        if (name.lastIndexOf(".txt") > 0) {
            name = name.substring(0, name.lastIndexOf(".txt"));
        }
        NameGenerator.readFile(file, name);
    }

    public static void readFile(File file, String groupName) throws Throwable {
        String s;
        NameList nameList = NameGenerator.loadNameList(groupName);
        BufferedReader in = new BufferedReader(new FileReader(file));
        while ((s = in.readLine()) != null) {
            if (s.indexOf("#") > -1) {
                s = s.substring(0, s.indexOf("#"));
            }
            if ((s = s.trim()).equals("")) continue;
            nameList.addName(s);
        }
        nameList.compileList();
    }

    protected static NameList loadNameList(String groupName) {
        if (nameMap.containsKey(groupName)) {
            return nameMap.get(groupName);
        }
        NameList nameList = new NameList();
        nameMap.put(groupName, nameList);
        return nameList;
    }

    public static void readFolder(File folder) throws Throwable {
        if (!folder.isDirectory()) {
            throw new IllegalArgumentException("Not a directory");
        }
        File[] folderList = folder.listFiles();
        int idx = 0;
        while (idx < folderList.length) {
            if (!folderList[idx].isDirectory()) {
                NameGenerator.readFile(folderList[idx]);
            }
            ++idx;
        }
    }

    public static String generateName(String nameList) {
        return NameGenerator.generateName(nameList, false);
    }

    public static String generateName(String nameList, boolean useWeight) {
        if (!nameMap.containsKey(nameList)) {
            return "";
        }
        return nameMap.get(nameList).generateName(useWeight);
    }

    public static String[] generateNames(String nameList, int amount) {
        return NameGenerator.generateNames(nameList, amount, false);
    }

    public static String[] generateNames(String nameList, int amount, boolean useWeight) {
        return NameGenerator.generateNames(nameList, amount, useWeight, 3, 20);
    }

    public static String[] generateNames(String nameList, int amount, boolean useWeight, int minLength, int maxLength) {
        if (!nameMap.containsKey(nameList)) {
            return new String[]{""};
        }
        return nameMap.get(nameList).generateNames(amount, useWeight, minLength, maxLength);
    }

    public static void removeList(String nameList) {
        if (nameMap.containsKey(nameList)) {
            nameMap.remove(nameList);
        }
    }

    public static int getReferenceSize(String nameList) {
        if (!nameMap.containsKey(nameList)) {
            return 0;
        }
        return nameMap.get(nameList).getReferenceSize();
    }

    public static int getDictionarySize(String nameList) {
        if (!nameMap.containsKey(nameList)) {
            return 0;
        }
        return nameMap.get(nameList).getDictionarySize();
    }

    public static String listPartsToString(String nameList) {
        if (!nameMap.containsKey(nameList)) {
            return "";
        }
        return nameMap.get(nameList).listPartsToString();
    }

    public static String getReferenceNames(String nameList) {
        if (!nameMap.containsKey(nameList)) {
            return "";
        }
        ArrayList<String> list = nameMap.get(nameList).getList();
        String splitChar = ",";
        int idx = 0;
        while (idx < list.size()) {
            if (list.get(idx).startsWith("$break char ")) {
                splitChar = list.get(idx).split(" ")[2];
            } else {
                list.set(idx, list.get(idx).replaceAll(splitChar, ""));
            }
            ++idx;
        }
        Collections.sort(list);
        String returnString = "";
        int idx2 = 0;
        while (idx2 < list.size()) {
            if (!list.get(idx2).startsWith("$")) {
                returnString = String.valueOf(returnString) + list.get(idx2) + newline;
            }
            ++idx2;
        }
        return returnString;
    }
}

