/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import net.mvw.namegenerator.NameGenerator;

public class NameGenMain
extends JFrame
implements ActionListener,
ItemListener {
    private static final long serialVersionUID = 266394613580695406L;

    public NameGenMain() {
        super("Name Generator");
    }

    protected JMenuBar createMenu() {
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(70);
        menuBar.add(fileMenu);
        JMenuItem closeItem = new JMenuItem("Close", 67);
        closeItem.setAccelerator(KeyStroke.getKeyStroke(115, 8));
        closeItem.setActionCommand("close");
        closeItem.addActionListener(this);
        fileMenu.add(closeItem);
        return menuBar;
    }

    protected Container createContent(Container container) {
        return container;
    }

    public static void main(String[] args) {
        try {
            int idx;
            String[] str;
            String file;
            if (args.length == 0) {
                System.out.println("Usage:");
                System.out.println("java -jar namegen.jar <filename[|filename2|...|filenameN]> [listname] [amount] [(lengthmin-lengthmax)] [UNWEIGHTED]");
                return;
            }
            String name = file = args[0];
            if (args.length >= 2) {
                name = args[1];
            }
            int amount = 5;
            if (args.length >= 3) {
                amount = Integer.parseInt(args[2]);
            }
            int min = 3;
            int max = 17;
            if (args.length >= 4 && args[3].startsWith("(") && args[3].endsWith(")") && (str = args[3].substring(1, args[3].lastIndexOf(")")).split(",")).length >= 2) {
                min = Integer.parseInt(str[0]);
                max = Integer.parseInt(str[1]);
            }
            boolean weighted = true;
            if (args.length >= 5 && args[4].toLowerCase().equals("unweighted")) {
                weighted = false;
            }
            System.out.println("==================");
            System.out.println("= NAME GENERATOR =");
            System.out.println("==================");
            System.out.println("");
            if (file.indexOf(",") > -1) {
                System.out.print("Reading files ");
                String[] files = file.split(",");
                idx = 0;
                while (idx < files.length) {
                    if (idx == files.length - 1) {
                        System.out.print(" and ");
                    } else if (idx > 0) {
                        System.out.print(", ");
                    }
                    System.out.print(files[idx]);
                    ++idx;
                }
                System.out.println(".");
            } else {
                System.out.println("Reading file " + file + ".");
            }
            NameGenerator.readFile(file, name);
            System.out.println("Loaded " + NameGenerator.getReferenceSize(name) + " names.");
            System.out.println("Dictionary contains " + NameGenerator.getDictionarySize(name) + " entries.");
            if (args.length >= 6 && args[5].equals("DEBUG")) {
                System.out.println("");
                System.out.println("Reference names");
                System.out.println("---------------");
                System.out.println(NameGenerator.getReferenceNames(name));
                System.out.println("");
                System.out.println("Name parts");
                System.out.println("----------");
                System.out.println(NameGenerator.listPartsToString(name));
            }
            System.out.println("");
            System.out.println("Generating " + amount + " names, using " + (weighted ? "weighted" : "unweighted") + " chances.");
            Object[] test = NameGenerator.generateNames(name, amount, weighted, min, max);
            if (test.length < amount) {
                System.out.println("Could only generate " + test.length + " names.");
            }
            System.out.println("");
            System.out.println("Sorting name list.");
            Arrays.sort(test);
            System.out.println("");
            idx = 0;
            while (idx < test.length) {
                System.out.println((String)test[idx]);
                ++idx;
            }
            System.out.println("");
            System.out.println("Done.");
            System.out.println("");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("close".equals(e.getActionCommand())) {
            System.exit(0);
        }
    }
}

