package com.mvw.allchemical.recipe;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;

import com.mvw.allchemical.Component;
import com.mvw.allchemical.Attribute;
import com.mvw.allchemical.Coordinate;
import com.mvw.allchemical.Group;
import com.mvw.allchemical.Layout;
import com.mvw.allchemical.Modifier;
import com.mvw.allchemical.Recipe;
import com.mvw.allchemical.Result;
import com.mvw.allchemical.Content;
import com.mvw.allchemical.ConditionalModifier;
import com.mvw.allchemical.ResultModifier;
import com.mvw.allchemical.ContentStack;

public class SizelessRecipe extends Recipe {
	
	public SizelessRecipe() {
		
	}
	
	protected SizelessRecipe(Content...content) {
		this(new ArrayList<Content>(Arrays.asList(content)));
	}
	
	protected SizelessRecipe(ArrayList<Content> content) {
		layout = new Layout(content);
	}
	
	@Override
	protected Recipe add(Layout layout, ArrayList<Component> result, boolean consumes, ArrayList<Modifier> modifiers, ArrayList<String> usageFlag) {
		SizelessRecipe recipe = new SizelessRecipe();
		recipe.layout = layout;
		recipe.result = result;
		recipe.consumes = consumes;
		recipe.modifiers = new ArrayList<Modifier>(modifiers);
		recipe.usageFlag = new ArrayList<String>(usageFlag);
		return recipe;
	}

	@Override
	public Result getResult(Layout layout, boolean[][] unused) {
		boolean[][] consumeMap = new boolean[layout.getHeight()][layout.getWidth()];
		HashMap<Integer, Integer> quantities = new HashMap<Integer, Integer>();
		ArrayList<Integer> indices = new ArrayList<Integer>();
		ArrayList<ContentStack> componentList = layout.getComponentList();
		ArrayList<ContentStack> modifiedList = layout.getComponentList();
		ArrayList<ContentStack> orderedList = new ArrayList<ContentStack>();
		ArrayList<Component> resultList = new ArrayList<Component>();
		ArrayList<ContentStack> components = this.layout.getComponentList();
		ArrayList<ContentStack> attributes = this.layout.getAttributeList();
		ArrayList<ContentStack> groups = this.layout.getGroupList();
		ArrayList<ContentStack> consumedList = new ArrayList<ContentStack>();
		int[][] consumedQuantity = new int[layout.getHeight()][layout.getWidth()]; 
		for(int i = 0; i < layout.getWidth() * layout.getHeight(); i++) {
			int x = i % layout.getWidth();
			int y = i / layout.getWidth();
			Content c = layout.getAt(x, y);
			int q = layout.getQuantityAt(x, y);
			if(c != null && c instanceof Component) {
				Component com = (Component) c;
				consumeMap[y][x] = true;
				consumedList.add(new ContentStack(com, q, new Coordinate(x, y), !unused[y][x]));
			}
		}
		Collections.sort(consumedList);
		Collections.sort(componentList);
		Collections.sort(components);
		Collections.sort(attributes);
		Collections.sort(groups);
		Result result = new Result();
		result.consumedComponents = consumeMap;
		if(componentList.size() < this.layout.getContentSize()) {
			return result;
		}
		for(int i = 0; i < componentList.size(); i++) {
			indices.add(i);
		}
		for(ContentStack componentStack : components) {
			boolean inModified = false;
			int iStack = 0;
			for(iStack = 0; iStack < modifiedList.size(); iStack++) {
				ContentStack modifiedStack = modifiedList.get(iStack);
				if(componentStack.content == modifiedStack.content) {
					inModified = true;
					break;
				}
			}
			if(!inModified) {
				return result;
			}
			modifiedList.remove(iStack);
			orderedList.add(componentStack);
			for(int i = 0; i < componentList.size(); i++) {
				if(componentList.get(i).content == componentStack.content && componentList.get(i).quantity <= componentStack.quantity && indices.contains(i)) {
					quantities.put(i, componentStack.quantity);
					indices.remove(indices.indexOf(i));
					break;
				}
			}
		}
		ArrayList<ContentStack> content = new ArrayList<ContentStack>();
		content.addAll(attributes);
		content.addAll(groups);
		if(!content.isEmpty()) {
			Subresult subresult = getCorrectResult(componentList, orderedList, content, indices, quantities);
			if(subresult.components.size() == 0) {
				return result;
			}
			indices = subresult.indices;
			quantities = subresult.quantities;
			orderedList = subresult.components;
		}
		resultList.addAll(this.result);
		Layout tLay = new Layout(this.layout);
		int attStart = this.layout.getComponentList().size();
		int grpStart = this.layout.getAttributeList().size() + attStart;
		ArrayList<Integer> idc = new ArrayList<Integer>();
		for(int x = 0; x < tLay.getWidth(); x++) {
			Content tCont = tLay.getAt(x, 0);
			if(tCont instanceof Attribute) {
				for(int aI = 0; aI < attributes.size(); aI++) {
					if(tCont == attributes.get(aI).content && !idc.contains(attStart + aI)) {
						idc.add(attStart + aI);
						tLay.setContent(orderedList.get(attStart + aI).content, x, 0);
						tLay.setQuantity(orderedList.get(attStart + aI).quantity, x, 0);
						break;
					}
				}
				continue;
			}
			if(tCont instanceof Group) {
				for(int gI = 0; gI < groups.size(); gI++) {
					if(tCont == groups.get(gI).content && !idc.contains(grpStart + gI)) {
						idc.add(grpStart + gI);
						tLay.setContent(orderedList.get(grpStart + gI).content, x, 0);
						tLay.setQuantity(orderedList.get(attStart + gI).quantity, x, 0);
						break;
					}
				}
				continue;
			}
		}
		for(Modifier modifier : modifiers) {
			if(modifier instanceof ResultModifier) {
				resultList.addAll(((ResultModifier)modifier).getResult(this, tLay));
			}
		}
		for(int i = 0; i < componentList.size(); i++) {
			if(!indices.contains(i)) {
				for(int j = 0; j < consumedList.size(); j++) {
					ContentStack ccp = consumedList.get(j);
					if(ccp.content == componentList.get(i).content) {
						consumeMap[ccp.coordinate.y][ccp.coordinate.x] = false;
						consumedQuantity[ccp.coordinate.y][ccp.coordinate.x] = Math.max(consumedQuantity[ccp.coordinate.y][ccp.coordinate.x], quantities.get(i));
						consumedList.remove(j);
						break;
					}
				}
			}
		}
		result.consumedComponents = consumeMap;
		result.resultComponents = resultList;
		result.quantity = consumedQuantity;
		return result;
	}
	
	protected Subresult getCorrectResult(ArrayList<ContentStack> componentList, ArrayList<ContentStack> currentList, ArrayList<ContentStack> content, ArrayList<Integer> indices, HashMap<Integer, Integer> quantities) {
		ContentStack c = content.get(0);
		Subresult subresult = new Subresult();
		for(int i = 0; i < componentList.size(); i++) {
			ArrayList<Integer> tIndices = new ArrayList<Integer>(indices);
			HashMap<Integer, Integer> tQuantities = new HashMap<Integer, Integer>(quantities);
			ArrayList<ContentStack> tCurrentList = new ArrayList<ContentStack>(currentList);
			ContentStack component = componentList.get(i);
			if(c.content instanceof Attribute && !((Component)component.content).getAttributes().contains((Attribute)c.content)) {
				continue;
			}
			if(c.content instanceof Group && ((Component)component.content).getGroup() != (Group)c.content) {
				continue;
			}
			if(!tIndices.contains(i)) {
				continue;
			}
			if(c.quantity > component.quantity) {
				continue;
			}
			tQuantities.put(i, c.quantity);
			tIndices.remove(tIndices.indexOf(i));
			tCurrentList.add(component);
			if(content.size() > 1) {
				ArrayList<ContentStack> tContent = new ArrayList<ContentStack>(content);
				tContent.remove(0);
				subresult = getCorrectResult(componentList, tCurrentList, tContent, tIndices, tQuantities);
				if(subresult.components.size() > 0) {
					return subresult;
				}
			} else {
				boolean isValid = true;
				Layout tLay = new Layout(layout);
				int attStart = layout.getComponentList().size();
				int grpStart = layout.getAttributeList().size() + attStart;
				ArrayList<Integer> idc = new ArrayList<Integer>();
				ArrayList<ContentStack> aList = layout.getAttributeList();
				ArrayList<ContentStack> gList = layout.getGroupList();
				Collections.sort(aList);
				Collections.sort(gList);
				for(int x = 0; x < tLay.getWidth(); x++) {
					Content tCont = tLay.getAt(x, 0);
					if(tCont instanceof Attribute) {
						for(int aI = 0; aI < aList.size(); aI++) {
							if(tCont == aList.get(aI).content && !idc.contains(attStart + aI)) {
								idc.add(attStart + aI);
								tLay.setContent(tCurrentList.get(attStart + aI).content, x, 0);
								tLay.setQuantity(tCurrentList.get(attStart + aI).quantity, x, 0);
								break;
							}
						}
						continue;
					}
					if(tCont instanceof Group) {
						for(int gI = 0; gI < gList.size(); gI++) {
							if(tCont == gList.get(gI).content && !idc.contains(grpStart + gI)) {
								idc.add(grpStart + gI);
								tLay.setContent(tCurrentList.get(grpStart + gI).content, x, 0);
								tLay.setQuantity(tCurrentList.get(attStart + gI).quantity, x, 0);
								break;
							}
						}
						continue;
					}
				}
				for(Modifier modifier : modifiers) {
					if(modifier instanceof ConditionalModifier) {
						if(!((ConditionalModifier)modifier).canCombine(this, tLay)) {
							isValid = false;
							break;
						}
					}
				}
				if(!isValid) {
					continue;
				}
				subresult.indices = tIndices;
				subresult.quantities = tQuantities;
				subresult.components = tCurrentList;
			}
		}
		return subresult;
	}
	
	protected class Subresult {
		public ArrayList<Integer> indices = new ArrayList<Integer>();
		public HashMap<Integer, Integer> quantities = new HashMap<Integer, Integer>();
		public ArrayList<ContentStack> components = new ArrayList<ContentStack>();
	}
}
