package com.mvw.allchemical.recipe;

import java.util.ArrayList;

import com.mvw.allchemical.Component;
import com.mvw.allchemical.Content;
import com.mvw.allchemical.ContentStack;
import com.mvw.allchemical.Coordinate;
import com.mvw.allchemical.Layout;
import com.mvw.allchemical.Modifier;
import com.mvw.allchemical.Recipe;
import com.mvw.allchemical.Result;

public class SimpleCraftingRecipe extends Recipe {
	
	public SimpleCraftingRecipe() {
		
	}

	@Override
	protected Recipe add(Layout layout, ArrayList<Component> result, boolean consumes, ArrayList<Modifier> modifiers, ArrayList<String> usageFlag) {
		SimpleCraftingRecipe recipe = new SimpleCraftingRecipe();
		recipe.layout = layout;
		recipe.result = result;
		recipe.consumes = true;
		recipe.modifiers = new ArrayList<Modifier>(modifiers);
		recipe.usageFlag = new ArrayList<String>(usageFlag);
		return recipe;
	}

	@Override
	public Result getResult(Layout layout, boolean[][] unused) {
		Result result = new Result();
		int totalQuantity = 0;
		int oTotalQuantity = 0;
		for(ContentStack c : this.layout.getContentList()) {
			totalQuantity+= c.quantity;
		}
		for(ContentStack c : layout.getContentList()) {
			oTotalQuantity+= c.quantity;
		}
		if(totalQuantity > oTotalQuantity) {
			return result;
		}
		ArrayList<ContentStack> components = this.layout.getComponentList();
		ArrayList<ContentStack> attributes = this.layout.getAttributeList();
		ArrayList<ContentStack> groups = this.layout.getGroupList();
		boolean[][] consumeMap = new boolean[layout.getHeight()][layout.getWidth()];
		int[][] consumedQuantity = new int[layout.getHeight()][layout.getWidth()]; 
		for(int i = 0; i < layout.getWidth() * layout.getHeight(); i++) {
			int x = i % layout.getWidth();
			int y = i / layout.getWidth();
			Content c = layout.getAt(x, y);
			if(c != null && c instanceof Component) {
				consumeMap[y][x] = true;
			}
		}
		for(ContentStack component : components) {
			int q = component.quantity;
			for(ContentStack lCom : layout.getComponentList()) {
				int curQ = consumedQuantity[lCom.coordinate.y][lCom.coordinate.x];
				int remQ = lCom.quantity - curQ;
				if(q > remQ) {
					consumedQuantity[lCom.coordinate.y][lCom.coordinate.x] = lCom.quantity;
					q-= remQ;
					continue;
				} else {
					consumedQuantity[lCom.coordinate.y][lCom.coordinate.x]+= q;
					q = 0;
					break;
				}
			}
			if(q > 0) {
				return result;
			}
		}
		return result;
	}

}
