package com.mvw.allchemical.recipe;

import java.util.ArrayList;
import java.util.Arrays;

import com.mvw.allchemical.Component;
import com.mvw.allchemical.Content;
import com.mvw.allchemical.Layout;
import com.mvw.allchemical.Modifier;
import com.mvw.allchemical.Recipe;
import com.mvw.allchemical.Result;

public class ShapelessRecipe extends SizelessRecipe {

	public ShapelessRecipe() {
		
	}
	
	protected ShapelessRecipe(Content...content) {
		this(new ArrayList<Content>(Arrays.asList(content)));
	}
	
	protected ShapelessRecipe(ArrayList<Content> content) {
		layout = new Layout(content);
	}

	@Override
	protected Recipe add(Layout layout, ArrayList<Component> result, boolean consumes, ArrayList<Modifier> modifiers, ArrayList<String> usageFlag) {
		ShapelessRecipe recipe = new ShapelessRecipe();
		recipe.layout = layout;
		recipe.result = result;
		recipe.consumes = consumes;
		recipe.modifiers = new ArrayList<Modifier>(modifiers);
		recipe.usageFlag = new ArrayList<String>(usageFlag);
		return recipe;
	}
	
	@Override
	public Result getResult(Layout layout, boolean[][] unused) {
		Result result = new Result();
		if(layout.getWidth() < this.layout.getWidth() || layout.getHeight() < this.layout.getHeight()) {
			return result;
		}
		for(int i = 0; i < layout.getWidth() * layout.getHeight(); i++) {
			int x = i % layout.getWidth();
			int y = i / layout.getWidth();
			Content c = layout.getAt(x, y);
			if(c != null && c instanceof Component) {
				result.consumedComponents[y][x] = true;
			}
		}		
		for(int y = 0; y <= layout.getHeight() - this.layout.getHeight(); y++) {
			for(int x = 0; x <= layout.getWidth() - this.layout.getWidth(); x++) {
				Layout nLay = new Layout(this.layout.getWidth(), this.layout.getHeight());
				boolean[][] nUnused = new boolean[this.layout.getHeight()][this.layout.getWidth()];
				for(int tY = 0; tY < this.layout.getHeight(); tY++) {
					for(int tX = 0; tX < this.layout.getWidth(); tX++) {
						Content content = layout.getAt(x + tX, y + tY);
						if(content != null) {
							nLay.setContent(content, tX, tY);
							nUnused[tY][tX] = unused[y + tY][x + tX];
						}
					}
				}
				Result tRes = super.getResult(nLay, nUnused);
				if(!tRes.resultComponents.isEmpty()) {
					result.resultComponents.addAll(tRes.resultComponents);
					for(int tY = 0; tY < this.layout.getHeight(); tY++) {
						for(int tX = 0; tX < this.layout.getWidth(); tX++) {
							result.consumedComponents[y + tY][x + tX] = result.consumedComponents[y + tY][x + tX] && tRes.consumedComponents[tY][tX];
						}
					}
					return result;
				}
			}
		}
		return result;
	}
}
