package com.mvw.allchemical.modifier;

import com.mvw.allchemical.ConditionalModifier;
import com.mvw.allchemical.Layout;
import com.mvw.allchemical.Modifier;
import com.mvw.allchemical.Recipe;

public class XorModifier extends NotModifier {

	@Override
	public boolean canCombine(Recipe recipe, Layout layout) {
		boolean hasChecked = false;
		for(Modifier modifier : conditionMod) {
			if(modifier instanceof ConditionalModifier && ((ConditionalModifier) modifier).canCombine(recipe, layout)) {
				hasChecked = !hasChecked;
			}
		}
		return hasChecked;
	}

	@Override
	protected Modifier getInstance(String string) {
		XorModifier modifier = new XorModifier();
		modifier.conditionMod.addAll(Modifier.parseModifiers(string));
		return modifier;
	}

	@Override
	protected Modifier getInstance(byte[] bytes) {
		XorModifier modifier = new XorModifier();
		modifier.conditionMod.addAll(Modifier.parseModifiers(bytes));
		return modifier;
	}

}
