package com.mvw.allchemical.modifier;

import com.mvw.allchemical.ConditionalModifier;
import com.mvw.allchemical.Layout;
import com.mvw.allchemical.Modifier;
import com.mvw.allchemical.Recipe;

public class OrModifier extends NotModifier {

	@Override
	public boolean canCombine(Recipe recipe, Layout layout) {
		for(Modifier modifier : conditionMod) {
			if(modifier instanceof ConditionalModifier && ((ConditionalModifier) modifier).canCombine(recipe, layout)) {
				return true;
			}
		}
		return false;
	}

	@Override
	protected Modifier getInstance(String string) {
		OrModifier modifier = new OrModifier();
		modifier.conditionMod.addAll(Modifier.parseModifiers(string));
		return modifier;
	}

	@Override
	protected Modifier getInstance(byte[] bytes) {
		OrModifier modifier = new OrModifier();
		modifier.conditionMod.addAll(Modifier.parseModifiers(bytes));
		return modifier;
	}
}
