package com.mvw.allchemical.modifier;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;

import com.mvw.allchemical.ConditionalModifier;
import com.mvw.allchemical.Layout;
import com.mvw.allchemical.MixedStackModifier;
import com.mvw.allchemical.Modifier;
import com.mvw.allchemical.Recipe;

public class NotModifier extends Modifier implements ConditionalModifier, MixedStackModifier {
	
	protected ArrayList<Modifier> conditionMod = new ArrayList<Modifier>();

	@Override
	public boolean canCombine(Recipe recipe, Layout layout) {
		for(Modifier modifier : conditionMod) {
			if(modifier instanceof ConditionalModifier && !((ConditionalModifier) modifier).canCombine(recipe, layout)) {
				return true;
			}
		}
		return false;
	}

	@Override
	protected Modifier getInstance(String string) {
		NotModifier modifier = new NotModifier();
		modifier.conditionMod.addAll(Modifier.parseModifiers(string));
		return modifier;
	}

	@Override
	protected Modifier getInstance(byte[] bytes) {
		NotModifier modifier = new NotModifier();
		modifier.conditionMod.addAll(Modifier.parseModifiers(bytes));
		return modifier;
	}

	@Override
	protected byte[] getData() {
		ByteArrayOutputStream dataStream = new ByteArrayOutputStream();
		byte[] cData = Modifier.getModifiersAsBytes(conditionMod);
		dataStream.write(id & 0xFF);
		dataStream.write((id >> 8) & 0xFF);
		dataStream.write(cData.length & 0xFF);
		dataStream.write((cData.length >> 8) & 0xFF);
		dataStream.write(cData, 0, cData.length);
		byte[] data = dataStream.toByteArray();
		return data;
	}
	
	@Override
	public String toString() {
		String s = name + "[";
		int i = 0;
		for(Modifier modifier : conditionMod) {
			if(i > 0) {
				s+= "|";
			}
			s+= modifier.toString();
			i++;
		}
		s+= "]";
		return s;
	}
}
