package com.mvw.allchemical.modifier;

import java.util.ArrayList;
import java.util.Arrays;

import com.mvw.allchemical.Component;
import com.mvw.allchemical.ConditionalModifier;
import com.mvw.allchemical.Content;
import com.mvw.allchemical.Coordinate;
import com.mvw.allchemical.Layout;
import com.mvw.allchemical.Modifier;
import com.mvw.allchemical.Recipe;

public class IsComponentModifier extends Modifier implements ConditionalModifier {

	protected ArrayList<Component> components = new ArrayList<Component>();
	protected ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
	
	@Override
	public boolean canCombine(Recipe recipe, Layout layout) {
		ArrayList<Component> cS = new ArrayList<Component>();
		ArrayList<Component> cD = new ArrayList<Component>();
		for(Component component : components) {
			if(!cS.contains(component)) {
				cS.add(component);
			}
		}
		for(Coordinate coordinate : coordinates) {
			Content content = layout.getAt(coordinate.x, coordinate.y);
			if(content instanceof Component && content != null) {
				Component component = (Component) content;
				if(!cS.contains(component)) {
					return false;
				}
				if(!cD.contains(component)) {
					cD.add(component);
				}
			}
		}
		return (cS.size() == cD.size());
	}

	@Override
	protected Modifier getInstance(String string) {
		IsComponentModifier modifier = new IsComponentModifier();
		String[] s = string.split(":");
		if(s.length < 2) {
			s = new String[2];
			s[0] = string;
			s[1] = "";
		}
		modifier.components = Modifier.parseComponents(s[0]);
		modifier.coordinates = Modifier.parseCoordinates(s[1]);
		return modifier;
	}

	@Override
	protected Modifier getInstance(byte[] bytes) {
		IsComponentModifier modifier = new IsComponentModifier();
		int start = 0;
		int length = (bytes[start] << 8) | bytes[start + 1];
		modifier.components = Modifier.parseComponents(Arrays.copyOfRange(bytes, start + 2, start + length * 4 + 2));
		start = length * 4 + 2;
		length = (bytes[start] << 8) | bytes[start + 1];
		modifier.coordinates = Modifier.parseCoordinates(Arrays.copyOfRange(bytes, start + 2, start + length * 4 + 2));
		return modifier;
	}

	@Override
	protected byte[] getData() {
		byte[] com = Modifier.getComponentsAsBytes(components);
		byte[] coord = Modifier.getCoordinatesAsBytes(coordinates);
		int length = com.length + coord.length + 2;
		byte[] data = new byte[length + 2];
		data[0] = (byte)(id & 0xFF);
		data[1] = (byte)((id >> 8) & 0xFF);
		data[2] = (byte)(length & 0xFF);
		data[3] = (byte)((length >> 8) & 0xFF);
		int idx = 4;
		for(int i = 0; i < com.length; i++) {
			data[idx] = com[i];
			idx++;
		}
		for(int i = 0; i < coord.length; i++) {
			data[idx] = coord[i];
			idx++;
		}
		return data;
	}

	@Override
	public String toString() {
		String s = name + "[";
		for(int i = 0; i < components.size(); i++) {
			if(i > 0) {
				s+= ",";
			}
			s+= components.get(i).getName();
		}
		s+= ":";
		for(int i = 0; i < coordinates.size(); i++) {
			if(i > 0) {
				s+= ",";
			}
			Coordinate coord = coordinates.get(i);
			s+= "(" + coord.x + "," + coord.y + ")";
		}
		s+= "]";
		return s;
	}
}
