package com.mvw.allchemical.modifier;

import java.util.ArrayList;
import java.util.Arrays;

import com.mvw.allchemical.Component;
import com.mvw.allchemical.ConditionalModifier;
import com.mvw.allchemical.Layout;
import com.mvw.allchemical.MixedStackModifier;
import com.mvw.allchemical.Modifier;
import com.mvw.allchemical.Recipe;
import com.mvw.allchemical.ResultModifier;

public class IfModifier extends Modifier implements ConditionalModifier, ResultModifier, MixedStackModifier {
	
	protected ArrayList<Modifier> conditionMod = new ArrayList<Modifier>();
	protected ArrayList<Modifier> ifMod = new ArrayList<Modifier>();
	protected ArrayList<Modifier> elseMod = new ArrayList<Modifier>();

	@Override
	public ArrayList<Component> getResult(Recipe recipe, Layout layout) {
		for(Modifier modifier : conditionMod) {
			if(modifier instanceof ConditionalModifier && !((ConditionalModifier) modifier).canCombine(recipe, layout)) {
				return getResult(recipe, layout, elseMod);
			}
		}
		return getResult(recipe, layout, ifMod);
	}
	
	protected ArrayList<Component> getResult(Recipe recipe, Layout layout, ArrayList<Modifier> modifiers) {
		ArrayList<Component> result = new ArrayList<Component>();
		for(Modifier modifier : modifiers) {
			if(modifier instanceof ResultModifier) {
				result.addAll(((ResultModifier) modifier).getResult(recipe, layout));
			}
		}
		return result;
	}

	@Override
	public boolean canCombine(Recipe recipe, Layout layout) {
		for(Modifier modifier : conditionMod) {
			if(modifier instanceof ConditionalModifier &&!((ConditionalModifier) modifier).canCombine(recipe, layout)) {
				return canCombine(recipe, layout, elseMod);
			}
		}
		return canCombine(recipe, layout, ifMod);
	}
	
	protected boolean canCombine(Recipe recipe, Layout layout, ArrayList<Modifier> modifiers) {
		for(Modifier modifier : modifiers) {
			if(modifier instanceof ConditionalModifier &&!((ConditionalModifier) modifier).canCombine(recipe, layout)) {
				return false;
			}
		}
		return true;
	}

	@Override
	protected Modifier getInstance(String string) {
		IfModifier modifier = new IfModifier();
		int index = 0;
		int startIndex = 0;
		int level = 0;
		int iteration = 0; 
		String[] split = {"?",":"};
		boolean found = false;
		while(!found) {
			int tagOpen = string.indexOf("[", index);
			int tagSplit = string.indexOf(split[iteration], index);
			if(level > 0) {
				tagSplit = string.indexOf("]", index);
			}
			if(tagSplit == -1) {
				if(iteration == 0) {
					iteration++;
				} else {
					found = true;
				}
				startIndex = index;
				continue;
			}
			if(tagOpen > -1 && tagOpen < tagSplit) {
				level++;
				index = tagOpen + 1;
			} else {
				if(level > 0) {
					level--;
				} else {
					if(iteration == 0) {
						modifier.conditionMod.addAll(Modifier.parseModifiers(string.substring(startIndex, tagSplit)));
						iteration++;
						index = tagSplit + 1;
						startIndex = index;
					} else {
						modifier.ifMod.addAll(Modifier.parseModifiers(string.substring(startIndex, tagSplit)));
						found = true;
					}
				}
			}
		}
		if(ifMod.isEmpty()) {
			modifier.ifMod.addAll(Modifier.parseModifiers(string.substring(startIndex)));
		} else {
			modifier.elseMod.addAll(Modifier.parseModifiers(string.substring(startIndex)));
		}
		return modifier;
	}

	@Override
	protected Modifier getInstance(byte[] bytes) {
		IfModifier modifier = new IfModifier();
		int start = 0;
		int length = (bytes[start] << 8) | bytes[start + 1];
		modifier.conditionMod = Modifier.parseModifiers(Arrays.copyOfRange(bytes, start + 2, start + length + 2));
		start = length + 2;
		length = (bytes[start] << 8) | bytes[start + 1];
		modifier.ifMod = Modifier.parseModifiers(Arrays.copyOfRange(bytes, start + 2, start + length + 2));
		start = length + 2;
		length = (bytes[start] << 8) | bytes[start + 1];
		modifier.elseMod = Modifier.parseModifiers(Arrays.copyOfRange(bytes, start + 2, start + length + 2));
		return modifier;
	}

	@Override
	protected byte[] getData() {
		byte[] cData = Modifier.getModifiersAsBytes(conditionMod);
		byte[] iData = Modifier.getModifiersAsBytes(ifMod);
		byte[] eData = Modifier.getModifiersAsBytes(elseMod);
		int length = cData.length + iData.length + eData.length;
		byte[] data = new byte[length + 4];
		data[0] = (byte)(id & 0xFF);
		data[1] = (byte)((id >> 8) & 0xFF);
		data[2] = (byte)(length & 0xFF);
		data[3] = (byte)((length >> 8) & 0xFF);
		int idx = 4;
		for(int i = 0; i < cData.length; i++) {
			data[idx] = cData[i];
			idx++;
		}
		for(int i = 0; i < iData.length; i++) {
			data[idx] = iData[i];
			idx++;
		}
		for(int i = 0; i < eData.length; i++) {
			data[idx] = eData[i];
			idx++;
		}
		return data;
	}

	@Override
	public String toString() {
		String s = "";
		s+= name;
		s+= "[";
		for(int i = 0; i < conditionMod.size(); i++) {
			if(i > 0) {
				s+= "|";
			}
			Modifier modifier = conditionMod.get(i);
			s+= modifier.toString();
		}
		s+= "?";
		for(int i = 0; i < ifMod.size(); i++) {
			if(i > 0) {
				s+= "|";
			}
			Modifier modifier = ifMod.get(i);
			s+= modifier.toString();
		}
		s+= ":";
		for(int i = 0; i < elseMod.size(); i++) {
			if(i > 0) {
				s+= "|";
			}
			Modifier modifier = elseMod.get(i);
			s+= modifier.toString();
		}
		s+= "]";
		return s;
	}
}
