package com.mvw.allchemical.modifier;

import java.util.ArrayList;

import com.mvw.allchemical.Component;
import com.mvw.allchemical.ConditionalModifier;
import com.mvw.allchemical.Content;
import com.mvw.allchemical.Coordinate;
import com.mvw.allchemical.Layout;
import com.mvw.allchemical.Modifier;
import com.mvw.allchemical.Recipe;

public class EqualsModifier extends Modifier implements ConditionalModifier {

	protected ArrayList<Coordinate> coordinates;

	@Override
	public boolean canCombine(Recipe recipe, Layout layout) {
		Component component = null;
		for(Coordinate coordinate : coordinates) {
			Content c = layout.getAt(coordinate.x, coordinate.y);
			if(c != null && c instanceof Component) {
				if(component == null) {
					component = (Component)c;
				} else {
					if(component != c) {
						return false;
					}
				}
			} else {
				return false;
			}
		}
		return true;
	}

	@Override
	protected Modifier getInstance(String string) {
		EqualsModifier modifier = new EqualsModifier();
		modifier.coordinates = Modifier.parseCoordinates(string);
		return modifier;
	}

	@Override
	protected Modifier getInstance(byte[] bytes) {
		EqualsModifier modifier = new EqualsModifier();
		modifier.coordinates = Modifier.parseCoordinates(bytes);
		return modifier;
	}

	@Override
	protected byte[] getData() {
		byte[] coords = Modifier.getCoordinatesAsBytes(coordinates);
		int length = coords.length + 2; 
		byte[] data = new byte[length + 2];
		data[0] = (byte)(id & 0xFF);
		data[1] = (byte)((id >> 8) & 0xFF);
		data[2] = (byte)(length & 0xFF);
		data[3] = (byte)((length >> 8) & 0xFF);
		for(int idx = 0; idx < coords.length; idx++) {
			data[idx + 4] = coords[idx];
		}
		return data;
	}

	@Override
	public String toString() {
		String s = "";
		s+= name;
		s+= "[";
		int i = 0;
		for(Coordinate coordinate : coordinates) {
			if(i > 0) {
				s+= ",";
			}
			s+= "(" + coordinate.x + "," + coordinate.y + ")";
			i++;
		}
		s+= "]";
		return s;
	}
}
