package com.mvw.allchemical;

import java.io.ByteArrayOutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;

public class Group extends Content {
	private static HashMap<Integer, Group> idMap = new HashMap<Integer, Group>();
	private static HashMap<String, Group> nameMap = new HashMap<String, Group>();
	private static ArrayList<Group> groupList = new ArrayList<Group>();
	
	private int color;
	private Group parent = null;
	private ArrayList<Group> children = new ArrayList<Group>();
	
	private Group(int id, String name, String realName, String description, int color) {
		this.id = id;
		this.name = name;
		this.realName = realName;
		this.description = description;
		this.color = color;
		idMap.put(id, this);
		nameMap.put(name, this);
		groupList.add(this);
	}
	
	@Override
	public int order() {
		return 1;
	}
	
	public static Group add(int id, String name) {
		return add(id, name, 0xFFFFFF);
	}
	
	public static Group add(int id, String name, int color) {
		return add(id, name, name, color);
	}
	
	public static Group add(int id, String name, String realName, int color) {
		return add(id, name, realName, realName, color);
	}
	
	public static Group add(int id, String name, String realName, String description, int color) {
		return new Group(id, name, realName, description, color);
	}
	
	public static Group add(int id, Group parent, String name) {
		return add(id, parent, name, name);
	}
	
	public static Group add(int id, Group parent, String name, String realName) {
		return add(id, parent, name, realName, realName);
	}
	
	public static Group add(int id, Group parent, String name, String realName, String description) {
		return add(id, name, realName, description, (parent != null ? parent.color : 0xFFFFFF));
	}
	
	public static Group add(int id, Group parent, String name, int color) {
		return add(id, parent, name, name, color);
	}
	
	public static Group add(int id, Group parent, String name, String realName, int color) {
		return add(id, parent, name, realName, realName, color);
	}
	
	public static Group add(int id, Group parent, String name, String realName, String description, int color) {
		Group group = add(id, name, realName, description, color);
		if(parent != null) {
			group.parent = parent;
			parent.children.add(group);
		}
		return group;
	}
	
	public static Group add(int id, int parent, String name) {
		return add(id, parent, name, name);
	}
	
	public static Group add(int id, int parent, String name, String realName) {
		return add(id, parent, name, realName, realName);
	}
	
	public static Group add(int id, int parent, String name, String realName, String description) {
		if(!idMap.containsKey(parent)) {
			return null;
		}
		Group pGroup = idMap.get(parent);
		return add(id, pGroup, name, realName, description);
	}
	
	public static Group add(int id, String parent, String name) {
		return add(id, parent, name, name);
	}
	
	public static Group add(int id, String parent, String name, String realName) {
		return add(id, parent, name, realName, realName);
	}
	
	public static Group add(int id, String parent, String name, String realName, String description) {
		if(!nameMap.containsKey(parent)) {
			return null;
		}
		Group pGroup = nameMap.get(parent);
		return add(id, pGroup, name, realName, description);
	}
	
	public static Group get(int id) {
		return idMap.get(id);
	}
	
	public static Group get(String name) {
		return nameMap.get(name);
	}
	
	public static ArrayList<Group> getAll() {
		return new ArrayList<Group>(groupList);
	}
	
	public int getColor() {
		return color;
	}
	
	public Group getParent() {
		return parent;
	}
	
	public ArrayList<Group> getChildren() {
		return new ArrayList<Group>(children);
	}
	
	public byte[] dumpData() {
		byte[] data = super.dumpData();
		ByteArrayOutputStream dataStream = new ByteArrayOutputStream();
		dataStream.write(data, 0, data.length);
		dataStream.write((color >> 16) & 0xFF);
		dataStream.write((color >> 8) & 0xFF);
		dataStream.write(color & 0xFF);
		dataStream.write((parent == null ? 0 : 1));
		if(parent != null) {
			dataStream.write(parent.getId() & 0xFF);
			dataStream.write((parent.getId() >> 8) & 0xFF);
			dataStream.write((parent.getId() >> 16) & 0xFF);
			dataStream.write((parent.getId() >> 24) & 0xFF);
		}
		data = dataStream.toByteArray();
		dataStream.reset();
		return data;
	}
	
	public static byte[] dumpFullData() {
		Charset encoding = Charset.forName("UTF-8");
		ByteArrayOutputStream dataStream = new ByteArrayOutputStream();
		byte[] str = "GRP".getBytes(encoding);
		dataStream.write(str, 0, str.length);
		dataStream.write(0);
		ByteArrayOutputStream subDataStream = new ByteArrayOutputStream();
		subDataStream.write(groupList.size() & 0xFF);
		subDataStream.write((groupList.size() >> 8) & 0xFF);
		subDataStream.write((groupList.size() >> 16) & 0xFF);
		subDataStream.write((groupList.size() >> 24) & 0xFF);
		for(Group group : groupList) {
			byte[] subData = group.dumpData();
			subDataStream.write(subData.length & 0xFF);
			subDataStream.write((subData.length >> 8) & 0xFF);
			subDataStream.write((subData.length >> 16) & 0xFF);
			subDataStream.write((subData.length >> 24) & 0xFF);
			subDataStream.write(subData, 0, subData.length);
		}
		byte[] allSub = subDataStream.toByteArray();
		subDataStream.reset();
		dataStream.write(allSub.length & 0xFF);
		dataStream.write((allSub.length >> 8) & 0xFF);
		dataStream.write((allSub.length >> 16) & 0xFF);
		dataStream.write((allSub.length >> 24) & 0xFF);
		dataStream.write(allSub, 0, allSub.length);
		byte[] data = dataStream.toByteArray();
		dataStream.reset();
		return data;
	}
}
