package com.mvw.allchemical;

public class ContentStack implements Comparable<ContentStack> {

	public Content content;
	public int quantity;
	public Coordinate coordinate;
	public boolean isUsed;
	
	public ContentStack(Content content, int quantity, Coordinate coordinate, boolean isUsed) {
		this.content  = content;
		this.quantity = quantity;
		this.coordinate = coordinate;
		this.isUsed = isUsed;
	}

	@Override
	public int compareTo(ContentStack o) {
		if(isUsed != o.isUsed) {
			return (isUsed ? -1 : 1);
		}
		if(quantity != o.quantity) {
			return (quantity > o.quantity ? 1 : -1);
		}
		return 0;
	}
}
