package com.mvw.allchemical;

import java.io.ByteArrayOutputStream;
import java.nio.charset.Charset;

public abstract class Content implements Comparable<Content> {
	protected int id;
	protected String name;
	protected String realName;
	protected String description;
	
	public int getId() {
		return id;
	}
	
	public String getName() {
		return name;
	}
	
	public String getRealName() {
		return realName;
	}
	
	public String getDescription() {
		return description;
	}
	
	public int order() {
		return 0;
	}
	
	@Override
	public int compareTo(Content o) {
		if(this == o) {
			return 0;
		}
		boolean tN = this == null;
		boolean oN = o == null;
		if(tN != oN) {
			return (oN ? 1 : -1);
		}
		int tT = order();
		int oT = o.order();
		if(tT != oT) {
			return (tT > oT ? 1 : -1);
		}
		if(id != o.id) {
			return (id > o.id ? 1 : -1);
		}
		return 0;
	}
	
	public byte[] dumpData() {
		Charset encoding = Charset.forName("UTF-8");
		ByteArrayOutputStream dataStream = new ByteArrayOutputStream();
		dataStream.write(id & 0xFF);
		dataStream.write((id >> 8) & 0xFF);
		dataStream.write((id >> 16) & 0xFF);
		dataStream.write((id >> 24) & 0xFF);
		dataStream.write((name.length() + 1) & 0xFF);
		byte[] str = name.getBytes(encoding);
		dataStream.write(str, 0, str.length);
		dataStream.write(0);
		dataStream.write((realName.length() + 1) & 0xFF);
		dataStream.write(((realName.length() + 1) >> 8) & 0xFF);
		str = realName.getBytes(encoding);
		dataStream.write(str, 0, str.length);
		dataStream.write(0);
		dataStream.write((description.length() + 1) & 0xFF);
		dataStream.write(((description.length() + 1) >> 8) & 0xFF);
		str = description.getBytes(encoding);
		dataStream.write(str, 0, str.length);
		dataStream.write(0);
		byte[] data = dataStream.toByteArray();
		dataStream.reset();
		return data;
	}
}
