package com.mvw.allchemical;

import java.io.ByteArrayOutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class Component extends Content {
	private static HashMap<Integer, Component> idMap = new HashMap<Integer, Component>();
	private static HashMap<String, Component> nameMap = new HashMap<String, Component>();
	private static HashMap<Group, ArrayList<Component>> perGroup = new HashMap<Group, ArrayList<Component>>();
	private static HashMap<Attribute, ArrayList<Component>> perAttribute = new HashMap<Attribute, ArrayList<Component>>();
	private static ArrayList<Component> componentList = new ArrayList<Component>();
	
	private Group group;
	private ArrayList<Attribute> attributes = new ArrayList<Attribute>();
	
	private Component(int id, String name, String realName, String description, Group group) {
		this.id = id;
		this.name = name;
		this.realName = realName;
		this.description = description;
		this.group = group;
		idMap.put(id,  this);
		nameMap.put(name, this);
		if(!perGroup.containsKey(group)) {
			perGroup.put(group, new ArrayList<Component>());
		}
		perGroup.get(group).add(this);
		componentList.add(this);
	}
	
	@Override
	public int order() {
		return 3;
	}
	
	public static Component add(int id, String name, int group) {
		return add(id, name, name, group);
	}
	
	public static Component add(int id, String name, String realName, int group) {
		return add(id, name, realName, realName, group);
	}
	
	public static Component add(int id, String name, String realName, String description, int group) {
		Group g = Group.get(group);
		if(g == null) {
			return null;
		}
		return add(id, name, realName, description, g);
	}

	public static Component add(int id, String name, String group) {
		return add(id, name, name, group);
	}
	
	public static Component add(int id, String name, String realName, String group) {
		return add(id, name, realName, realName, group);
	}
	
	public static Component add(int id, String name, String realName, String description, String group) {
		Group g = Group.get(group);
		if(g == null) {
			return null;
		}
		return add(id, name, realName, description, g);
	}

	public static Component add(int id, String name, Group group) {
		return add(id, name, name, group);
	}
	
	public static Component add(int id, String name, String realName, Group group) {
		return add(id, name, realName, realName, group);
	}
	
	public static Component add(int id, String name, String realName, String description, Group group) {
		return new Component(id, name, realName, description, group);
	}
	
	public static void setAttributes(int id, Attribute...attributes) {
		setAttributes(id, new ArrayList<Attribute>(Arrays.asList(attributes)));
	}
	
	public static void setAttributes(int id, ArrayList<Attribute> attributes) {
		if(idMap.containsKey(id)) {
			setAttributes(idMap.get(id), attributes);
		}
	}

	public static void setAttributes(String name, Attribute...attributes) {
		setAttributes(name, new ArrayList<Attribute>(Arrays.asList(attributes)));
	}
	
	public static void setAttributes(String name, ArrayList<Attribute> attributes) {
		if(nameMap.containsKey(name)) {
			setAttributes(nameMap.get(name), attributes);
		}
	}

	public static void setAttributes(Component component, Attribute...attributes) {
		setAttributes(component, new ArrayList<Attribute>(Arrays.asList(attributes)));
	}
	
	public static void setAttributes(Component component, ArrayList<Attribute> attributes) {
		for(Attribute attribute : attributes) {
			if(!perAttribute.containsKey(attribute)) {
				perAttribute.put(attribute, new ArrayList<Component>());
			}
			if(!perAttribute.get(attribute).contains(component)) {
				perAttribute.get(attribute).add(component);
			}
		}
		component.attributes = attributes;
	}
	
	public static Component get(int id) {
		return idMap.get(id);
	}
	
	public static Component get(String name) {
		return nameMap.get(name);
	}
	
	public static ArrayList<Component> getAll() {
		return new ArrayList<Component>(componentList);
	}

	public static ArrayList<Component> getAllPerAttribute(String name) {
		Attribute attribute = Attribute.get(name);
		if(attribute == null) {
			return null;
		}
		return getAllPerAttribute(attribute);
	}
	
	public static ArrayList<Component> getAllPerAttribute(int id) {
		Attribute attribute = Attribute.get(id);
		if(attribute == null) {
			return null;
		}
		return getAllPerAttribute(attribute);
	}
	
	public static ArrayList<Component> getAllPerAttribute(Attribute attribute) {
		if(!perAttribute.containsKey(attribute)) {
			return new ArrayList<Component>();
		}
		return new ArrayList<Component>(perAttribute.get(attribute));
	}
	
	public String getName() {
		return name;
	}
	
	public String getRealName() {
		return realName;
	}
	
	public String getDescription() {
		return description;
	}
	
	public Group getGroup() {
		return group;
	}
	
	public ArrayList<Attribute> getAttributes() {
		return new ArrayList<Attribute>(attributes);
	}

	public byte[] dumpData() {
		byte[] data = super.dumpData();
		ByteArrayOutputStream dataStream = new ByteArrayOutputStream();
		dataStream.write(data, 0, data.length);
		dataStream.write(group.getId() & 0xFF);
		dataStream.write((group.getId() >> 8) & 0xFF);
		dataStream.write((group.getId() >> 16) & 0xFF);
		dataStream.write((group.getId() >> 24) & 0xFF);
		dataStream.write(attributes.size() & 0xFF);
		dataStream.write((attributes.size() >> 8) & 0xFF);
		dataStream.write((attributes.size() >> 16) & 0xFF);
		dataStream.write((attributes.size() >> 24) & 0xFF);
		for(Attribute attribute : attributes) {
			dataStream.write(attribute.getId() & 0xFF);
			dataStream.write((attribute.getId() >> 8) & 0xFF);
			dataStream.write((attribute.getId() >> 16) & 0xFF);
			dataStream.write((attribute.getId() >> 24) & 0xFF);
		}
		data = dataStream.toByteArray();
		dataStream.reset();
		return data;
	}

	public static byte[] dumpFullData() {
		Charset encoding = Charset.forName("UTF-8");
		ByteArrayOutputStream dataStream = new ByteArrayOutputStream();
		byte[] str = "CMP".getBytes(encoding);
		dataStream.write(str, 0, str.length);
		dataStream.write(0);
		ByteArrayOutputStream subDataStream = new ByteArrayOutputStream();
		subDataStream.write(componentList.size() & 0xFF);
		subDataStream.write((componentList.size() >> 8) & 0xFF);
		subDataStream.write((componentList.size() >> 16) & 0xFF);
		subDataStream.write((componentList.size() >> 24) & 0xFF);
		for(Component component : componentList) {
			byte[] subData = component.dumpData();
			subDataStream.write(subData.length & 0xFF);
			subDataStream.write((subData.length >> 8) & 0xFF);
			subDataStream.write((subData.length >> 16) & 0xFF);
			subDataStream.write((subData.length >> 24) & 0xFF);
			subDataStream.write(subData, 0, subData.length);
		}
		byte[] allSub = subDataStream.toByteArray();
		subDataStream.reset();
		dataStream.write(allSub.length & 0xFF);
		dataStream.write((allSub.length >> 8) & 0xFF);
		dataStream.write((allSub.length >> 16) & 0xFF);
		dataStream.write((allSub.length >> 24) & 0xFF);
		dataStream.write(allSub, 0, allSub.length);
		byte[] data = dataStream.toByteArray();
		dataStream.reset();
		return data;
	}
}
