/*
 * Decompiled with CFR 0.152.
 */
package com.mvw.allchemical.recipe;

import com.mvw.allchemical.Attribute;
import com.mvw.allchemical.Component;
import com.mvw.allchemical.ConditionalModifier;
import com.mvw.allchemical.Content;
import com.mvw.allchemical.ContentStack;
import com.mvw.allchemical.Coordinate;
import com.mvw.allchemical.Group;
import com.mvw.allchemical.Layout;
import com.mvw.allchemical.Modifier;
import com.mvw.allchemical.Recipe;
import com.mvw.allchemical.Result;
import com.mvw.allchemical.ResultModifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;

public class SizelessRecipe
extends Recipe {
    public SizelessRecipe() {
    }

    protected SizelessRecipe(Content ... content) {
        this(new ArrayList<Content>(Arrays.asList(content)));
    }

    protected SizelessRecipe(ArrayList<Content> content) {
        this.layout = new Layout(content);
    }

    @Override
    protected Recipe add(Layout layout, ArrayList<Component> result, boolean consumes, ArrayList<Modifier> modifiers, ArrayList<String> usageFlag) {
        SizelessRecipe recipe = new SizelessRecipe();
        recipe.layout = layout;
        recipe.result = result;
        recipe.consumes = consumes;
        recipe.modifiers = new ArrayList<Modifier>(modifiers);
        recipe.usageFlag = new ArrayList<String>(usageFlag);
        return recipe;
    }

    @Override
    public Result getResult(Layout layout, boolean[][] unused) {
        boolean[][] consumeMap = new boolean[layout.getHeight()][layout.getWidth()];
        HashMap<Integer, Integer> quantities = new HashMap<Integer, Integer>();
        ArrayList<Integer> indices = new ArrayList<Integer>();
        ArrayList<ContentStack> componentList = layout.getComponentList();
        ArrayList<ContentStack> modifiedList = layout.getComponentList();
        ArrayList<ContentStack> orderedList = new ArrayList<ContentStack>();
        ArrayList<Component> resultList = new ArrayList<Component>();
        ArrayList<ContentStack> components = this.layout.getComponentList();
        ArrayList<ContentStack> attributes = this.layout.getAttributeList();
        ArrayList<ContentStack> groups = this.layout.getGroupList();
        ArrayList<ContentStack> consumedList = new ArrayList<ContentStack>();
        int[][] consumedQuantity = new int[layout.getHeight()][layout.getWidth()];
        int i = 0;
        while (i < layout.getWidth() * layout.getHeight()) {
            int x = i % layout.getWidth();
            int y = i / layout.getWidth();
            Content c = layout.getAt(x, y);
            int q = layout.getQuantityAt(x, y);
            if (c != null && c instanceof Component) {
                Component com = (Component)c;
                consumeMap[y][x] = true;
                consumedList.add(new ContentStack(com, q, new Coordinate(x, y), !unused[y][x]));
            }
            ++i;
        }
        Collections.sort(consumedList);
        Collections.sort(componentList);
        Collections.sort(components);
        Collections.sort(attributes);
        Collections.sort(groups);
        Result result = new Result();
        result.consumedComponents = consumeMap;
        if (componentList.size() < this.layout.getContentSize()) {
            return result;
        }
        int i2 = 0;
        while (i2 < componentList.size()) {
            indices.add(i2);
            ++i2;
        }
        block2: for (ContentStack componentStack : components) {
            boolean inModified = false;
            int iStack = 0;
            iStack = 0;
            while (iStack < modifiedList.size()) {
                ContentStack modifiedStack = modifiedList.get(iStack);
                if (componentStack.content == modifiedStack.content) {
                    inModified = true;
                    break;
                }
                ++iStack;
            }
            if (!inModified) {
                return result;
            }
            modifiedList.remove(iStack);
            orderedList.add(componentStack);
            int i3 = 0;
            while (i3 < componentList.size()) {
                if (componentList.get((int)i3).content == componentStack.content && componentList.get((int)i3).quantity <= componentStack.quantity && indices.contains(i3)) {
                    quantities.put(i3, componentStack.quantity);
                    indices.remove(indices.indexOf(i3));
                    continue block2;
                }
                ++i3;
            }
        }
        ArrayList<ContentStack> content = new ArrayList<ContentStack>();
        content.addAll(attributes);
        content.addAll(groups);
        if (!content.isEmpty()) {
            Subresult subresult = this.getCorrectResult(componentList, orderedList, content, indices, quantities);
            if (subresult.components.size() == 0) {
                return result;
            }
            indices = subresult.indices;
            quantities = subresult.quantities;
            orderedList = subresult.components;
        }
        resultList.addAll(this.result);
        Layout tLay = new Layout(this.layout);
        int attStart = this.layout.getComponentList().size();
        int grpStart = this.layout.getAttributeList().size() + attStart;
        ArrayList<Integer> idc = new ArrayList<Integer>();
        int x = 0;
        while (x < tLay.getWidth()) {
            Content tCont = tLay.getAt(x, 0);
            if (tCont instanceof Attribute) {
                int aI = 0;
                while (aI < attributes.size()) {
                    if (tCont == attributes.get((int)aI).content && !idc.contains(attStart + aI)) {
                        idc.add(attStart + aI);
                        tLay.setContent(orderedList.get((int)(attStart + aI)).content, x, 0);
                        tLay.setQuantity(orderedList.get((int)(attStart + aI)).quantity, x, 0);
                        break;
                    }
                    ++aI;
                }
            } else if (tCont instanceof Group) {
                int gI = 0;
                while (gI < groups.size()) {
                    if (tCont == groups.get((int)gI).content && !idc.contains(grpStart + gI)) {
                        idc.add(grpStart + gI);
                        tLay.setContent(orderedList.get((int)(grpStart + gI)).content, x, 0);
                        tLay.setQuantity(orderedList.get((int)(attStart + gI)).quantity, x, 0);
                        break;
                    }
                    ++gI;
                }
            }
            ++x;
        }
        for (Modifier modifier : this.modifiers) {
            if (!(modifier instanceof ResultModifier)) continue;
            resultList.addAll(((ResultModifier)((Object)modifier)).getResult(this, tLay));
        }
        int i4 = 0;
        while (i4 < componentList.size()) {
            if (!indices.contains(i4)) {
                int j = 0;
                while (j < consumedList.size()) {
                    ContentStack ccp = (ContentStack)consumedList.get(j);
                    if (ccp.content == componentList.get((int)i4).content) {
                        consumeMap[ccp.coordinate.y][ccp.coordinate.x] = false;
                        consumedQuantity[ccp.coordinate.y][ccp.coordinate.x] = Math.max(consumedQuantity[ccp.coordinate.y][ccp.coordinate.x], quantities.get(i4));
                        consumedList.remove(j);
                        break;
                    }
                    ++j;
                }
            }
            ++i4;
        }
        result.consumedComponents = consumeMap;
        result.resultComponents = resultList;
        result.quantity = consumedQuantity;
        return result;
    }

    protected Subresult getCorrectResult(ArrayList<ContentStack> componentList, ArrayList<ContentStack> currentList, ArrayList<ContentStack> content, ArrayList<Integer> indices, HashMap<Integer, Integer> quantities) {
        ContentStack c = content.get(0);
        Subresult subresult = new Subresult();
        int i = 0;
        while (i < componentList.size()) {
            ArrayList<Integer> tIndices = new ArrayList<Integer>(indices);
            HashMap<Integer, Integer> tQuantities = new HashMap<Integer, Integer>(quantities);
            ArrayList<ContentStack> tCurrentList = new ArrayList<ContentStack>(currentList);
            ContentStack component = componentList.get(i);
            if (!(c.content instanceof Attribute && !((Component)component.content).getAttributes().contains((Attribute)c.content) || c.content instanceof Group && ((Component)component.content).getGroup() != (Group)c.content || !tIndices.contains(i) || c.quantity > component.quantity)) {
                tQuantities.put(i, c.quantity);
                tIndices.remove(tIndices.indexOf(i));
                tCurrentList.add(component);
                if (content.size() > 1) {
                    ArrayList<ContentStack> tContent = new ArrayList<ContentStack>(content);
                    tContent.remove(0);
                    subresult = this.getCorrectResult(componentList, tCurrentList, tContent, tIndices, tQuantities);
                    if (subresult.components.size() > 0) {
                        return subresult;
                    }
                } else {
                    boolean isValid = true;
                    Layout tLay = new Layout(this.layout);
                    int attStart = this.layout.getComponentList().size();
                    int grpStart = this.layout.getAttributeList().size() + attStart;
                    ArrayList<Integer> idc = new ArrayList<Integer>();
                    ArrayList<ContentStack> aList = this.layout.getAttributeList();
                    ArrayList<ContentStack> gList = this.layout.getGroupList();
                    Collections.sort(aList);
                    Collections.sort(gList);
                    int x = 0;
                    while (x < tLay.getWidth()) {
                        Content tCont = tLay.getAt(x, 0);
                        if (tCont instanceof Attribute) {
                            int aI = 0;
                            while (aI < aList.size()) {
                                if (tCont == aList.get((int)aI).content && !idc.contains(attStart + aI)) {
                                    idc.add(attStart + aI);
                                    tLay.setContent(tCurrentList.get((int)(attStart + aI)).content, x, 0);
                                    tLay.setQuantity(tCurrentList.get((int)(attStart + aI)).quantity, x, 0);
                                    break;
                                }
                                ++aI;
                            }
                        } else if (tCont instanceof Group) {
                            int gI = 0;
                            while (gI < gList.size()) {
                                if (tCont == gList.get((int)gI).content && !idc.contains(grpStart + gI)) {
                                    idc.add(grpStart + gI);
                                    tLay.setContent(tCurrentList.get((int)(grpStart + gI)).content, x, 0);
                                    tLay.setQuantity(tCurrentList.get((int)(attStart + gI)).quantity, x, 0);
                                    break;
                                }
                                ++gI;
                            }
                        }
                        ++x;
                    }
                    for (Modifier modifier : this.modifiers) {
                        if (!(modifier instanceof ConditionalModifier) || ((ConditionalModifier)((Object)modifier)).canCombine(this, tLay)) continue;
                        isValid = false;
                        break;
                    }
                    if (isValid) {
                        subresult.indices = tIndices;
                        subresult.quantities = tQuantities;
                        subresult.components = tCurrentList;
                    }
                }
            }
            ++i;
        }
        return subresult;
    }

    protected class Subresult {
        public ArrayList<Integer> indices = new ArrayList();
        public HashMap<Integer, Integer> quantities = new HashMap();
        public ArrayList<ContentStack> components = new ArrayList();

        protected Subresult() {
        }
    }
}

