/*
 * Decompiled with CFR 0.152.
 */
package com.mvw.allchemical.recipe;

import com.mvw.allchemical.Component;
import com.mvw.allchemical.Content;
import com.mvw.allchemical.ContentStack;
import com.mvw.allchemical.Layout;
import com.mvw.allchemical.Modifier;
import com.mvw.allchemical.Recipe;
import com.mvw.allchemical.Result;
import java.util.ArrayList;

public class SimpleCraftingRecipe
extends Recipe {
    @Override
    protected Recipe add(Layout layout, ArrayList<Component> result, boolean consumes, ArrayList<Modifier> modifiers, ArrayList<String> usageFlag) {
        SimpleCraftingRecipe recipe = new SimpleCraftingRecipe();
        recipe.layout = layout;
        recipe.result = result;
        recipe.consumes = true;
        recipe.modifiers = new ArrayList<Modifier>(modifiers);
        recipe.usageFlag = new ArrayList<String>(usageFlag);
        return recipe;
    }

    @Override
    public Result getResult(Layout layout, boolean[][] unused) {
        Result result = new Result();
        int totalQuantity = 0;
        int oTotalQuantity = 0;
        for (ContentStack c : this.layout.getContentList()) {
            totalQuantity += c.quantity;
        }
        for (ContentStack c : layout.getContentList()) {
            oTotalQuantity += c.quantity;
        }
        if (totalQuantity > oTotalQuantity) {
            return result;
        }
        ArrayList<ContentStack> components = this.layout.getComponentList();
        ArrayList<ContentStack> attributes = this.layout.getAttributeList();
        ArrayList<ContentStack> groups = this.layout.getGroupList();
        boolean[][] consumeMap = new boolean[layout.getHeight()][layout.getWidth()];
        int[][] consumedQuantity = new int[layout.getHeight()][layout.getWidth()];
        int i = 0;
        while (i < layout.getWidth() * layout.getHeight()) {
            int y;
            int x = i % layout.getWidth();
            Content c = layout.getAt(x, y = i / layout.getWidth());
            if (c != null && c instanceof Component) {
                consumeMap[y][x] = true;
            }
            ++i;
        }
        for (ContentStack component : components) {
            int q = component.quantity;
            for (ContentStack lCom : layout.getComponentList()) {
                int curQ = consumedQuantity[lCom.coordinate.y][lCom.coordinate.x];
                int remQ = lCom.quantity - curQ;
                if (q > remQ) {
                    consumedQuantity[lCom.coordinate.y][lCom.coordinate.x] = lCom.quantity;
                    q -= remQ;
                    continue;
                }
                int[] nArray = consumedQuantity[lCom.coordinate.y];
                int n = lCom.coordinate.x;
                nArray[n] = nArray[n] + q;
                q = 0;
                break;
            }
            if (q <= 0) continue;
            return result;
        }
        return result;
    }
}

