/*
 * Decompiled with CFR 0.152.
 */
package com.mvw.allchemical.recipe;

import com.mvw.allchemical.Component;
import com.mvw.allchemical.Content;
import com.mvw.allchemical.Layout;
import com.mvw.allchemical.Modifier;
import com.mvw.allchemical.Recipe;
import com.mvw.allchemical.Result;
import com.mvw.allchemical.recipe.SizelessRecipe;
import java.util.ArrayList;
import java.util.Arrays;

public class ShapelessRecipe
extends SizelessRecipe {
    public ShapelessRecipe() {
    }

    protected ShapelessRecipe(Content ... content) {
        this(new ArrayList<Content>(Arrays.asList(content)));
    }

    protected ShapelessRecipe(ArrayList<Content> content) {
        this.layout = new Layout(content);
    }

    @Override
    protected Recipe add(Layout layout, ArrayList<Component> result, boolean consumes, ArrayList<Modifier> modifiers, ArrayList<String> usageFlag) {
        ShapelessRecipe recipe = new ShapelessRecipe();
        recipe.layout = layout;
        recipe.result = result;
        recipe.consumes = consumes;
        recipe.modifiers = new ArrayList<Modifier>(modifiers);
        recipe.usageFlag = new ArrayList<String>(usageFlag);
        return recipe;
    }

    @Override
    public Result getResult(Layout layout, boolean[][] unused) {
        int x;
        Result result = new Result();
        if (layout.getWidth() < this.layout.getWidth() || layout.getHeight() < this.layout.getHeight()) {
            return result;
        }
        int i = 0;
        while (i < layout.getWidth() * layout.getHeight()) {
            int y;
            x = i % layout.getWidth();
            Content c = layout.getAt(x, y = i / layout.getWidth());
            if (c != null && c instanceof Component) {
                result.consumedComponents[y][x] = true;
            }
            ++i;
        }
        int y = 0;
        while (y <= layout.getHeight() - this.layout.getHeight()) {
            x = 0;
            while (x <= layout.getWidth() - this.layout.getWidth()) {
                Layout nLay = new Layout(this.layout.getWidth(), this.layout.getHeight());
                boolean[][] nUnused = new boolean[this.layout.getHeight()][this.layout.getWidth()];
                int tY = 0;
                while (tY < this.layout.getHeight()) {
                    int tX = 0;
                    while (tX < this.layout.getWidth()) {
                        Content content = layout.getAt(x + tX, y + tY);
                        if (content != null) {
                            nLay.setContent(content, tX, tY);
                            nUnused[tY][tX] = unused[y + tY][x + tX];
                        }
                        ++tX;
                    }
                    ++tY;
                }
                Result tRes = super.getResult(nLay, nUnused);
                if (!tRes.resultComponents.isEmpty()) {
                    result.resultComponents.addAll(tRes.resultComponents);
                    int tY2 = 0;
                    while (tY2 < this.layout.getHeight()) {
                        int tX = 0;
                        while (tX < this.layout.getWidth()) {
                            result.consumedComponents[y + tY2][x + tX] = result.consumedComponents[y + tY2][x + tX] && tRes.consumedComponents[tY2][tX];
                            ++tX;
                        }
                        ++tY2;
                    }
                    return result;
                }
                ++x;
            }
            ++y;
        }
        return result;
    }
}

