/*
 * Decompiled with CFR 0.152.
 */
package com.mvw.allchemical.modifier;

import com.mvw.allchemical.Component;
import com.mvw.allchemical.Content;
import com.mvw.allchemical.Coordinate;
import com.mvw.allchemical.Layout;
import com.mvw.allchemical.Modifier;
import com.mvw.allchemical.Recipe;
import com.mvw.allchemical.ResultModifier;
import java.util.ArrayList;

public class PreserveModifier
extends Modifier
implements ResultModifier {
    protected ArrayList<Coordinate> coordinates;

    @Override
    public ArrayList<Component> getResult(Recipe recipe, Layout layout) {
        ArrayList<Component> result = new ArrayList<Component>();
        for (Coordinate coordinate : this.coordinates) {
            Content c = layout.getAt(coordinate.x, coordinate.y);
            if (c == null || !(c instanceof Component)) continue;
            result.add((Component)c);
        }
        return result;
    }

    @Override
    protected Modifier getInstance(String string) {
        PreserveModifier modifier = new PreserveModifier();
        modifier.coordinates = Modifier.parseCoordinates(string);
        return modifier;
    }

    @Override
    protected Modifier getInstance(byte[] bytes) {
        PreserveModifier modifier = new PreserveModifier();
        modifier.coordinates = Modifier.parseCoordinates(bytes);
        return modifier;
    }

    @Override
    protected byte[] getData() {
        byte[] coords = Modifier.getCoordinatesAsBytes(this.coordinates);
        int length = coords.length + 2;
        byte[] data = new byte[length + 2];
        data[0] = (byte)(this.id & 0xFF);
        data[1] = (byte)(this.id >> 8 & 0xFF);
        data[2] = (byte)(length & 0xFF);
        data[3] = (byte)(length >> 8 & 0xFF);
        int idx = 0;
        while (idx < coords.length) {
            data[idx + 4] = coords[idx];
            ++idx;
        }
        return data;
    }

    public String toString() {
        String s = "";
        s = String.valueOf(s) + this.name;
        s = String.valueOf(s) + "[";
        int i = 0;
        for (Coordinate coordinate : this.coordinates) {
            if (i > 0) {
                s = String.valueOf(s) + ",";
            }
            s = String.valueOf(s) + "(" + coordinate.x + "," + coordinate.y + ")";
            ++i;
        }
        s = String.valueOf(s) + "]";
        return s;
    }
}

