/*
 * Decompiled with CFR 0.152.
 */
package com.mvw.allchemical.modifier;

import com.mvw.allchemical.Component;
import com.mvw.allchemical.ConditionalModifier;
import com.mvw.allchemical.Content;
import com.mvw.allchemical.Coordinate;
import com.mvw.allchemical.Layout;
import com.mvw.allchemical.Modifier;
import com.mvw.allchemical.Recipe;
import java.util.ArrayList;
import java.util.Arrays;

public class IsComponentModifier
extends Modifier
implements ConditionalModifier {
    protected ArrayList<Component> components = new ArrayList();
    protected ArrayList<Coordinate> coordinates = new ArrayList();

    @Override
    public boolean canCombine(Recipe recipe, Layout layout) {
        ArrayList<Component> cS = new ArrayList<Component>();
        ArrayList<Component> cD = new ArrayList<Component>();
        for (Component component : this.components) {
            if (cS.contains(component)) continue;
            cS.add(component);
        }
        for (Coordinate coordinate : this.coordinates) {
            Content content = layout.getAt(coordinate.x, coordinate.y);
            if (!(content instanceof Component) || content == null) continue;
            Component component = (Component)content;
            if (!cS.contains(component)) {
                return false;
            }
            if (cD.contains(component)) continue;
            cD.add(component);
        }
        return cS.size() == cD.size();
    }

    @Override
    protected Modifier getInstance(String string) {
        IsComponentModifier modifier = new IsComponentModifier();
        String[] s = string.split(":");
        if (s.length < 2) {
            s = new String[]{string, ""};
        }
        modifier.components = Modifier.parseComponents(s[0]);
        modifier.coordinates = Modifier.parseCoordinates(s[1]);
        return modifier;
    }

    @Override
    protected Modifier getInstance(byte[] bytes) {
        IsComponentModifier modifier = new IsComponentModifier();
        int start = 0;
        int length = bytes[start] << 8 | bytes[start + 1];
        modifier.components = Modifier.parseComponents(Arrays.copyOfRange(bytes, start + 2, start + length * 4 + 2));
        start = length * 4 + 2;
        length = bytes[start] << 8 | bytes[start + 1];
        modifier.coordinates = Modifier.parseCoordinates(Arrays.copyOfRange(bytes, start + 2, start + length * 4 + 2));
        return modifier;
    }

    @Override
    protected byte[] getData() {
        byte[] com = Modifier.getComponentsAsBytes(this.components);
        byte[] coord = Modifier.getCoordinatesAsBytes(this.coordinates);
        int length = com.length + coord.length + 2;
        byte[] data = new byte[length + 2];
        data[0] = (byte)(this.id & 0xFF);
        data[1] = (byte)(this.id >> 8 & 0xFF);
        data[2] = (byte)(length & 0xFF);
        data[3] = (byte)(length >> 8 & 0xFF);
        int idx = 4;
        int i = 0;
        while (i < com.length) {
            data[idx] = com[i];
            ++idx;
            ++i;
        }
        i = 0;
        while (i < coord.length) {
            data[idx] = coord[i];
            ++idx;
            ++i;
        }
        return data;
    }

    public String toString() {
        String s = String.valueOf(this.name) + "[";
        int i = 0;
        while (i < this.components.size()) {
            if (i > 0) {
                s = String.valueOf(s) + ",";
            }
            s = String.valueOf(s) + this.components.get(i).getName();
            ++i;
        }
        s = String.valueOf(s) + ":";
        i = 0;
        while (i < this.coordinates.size()) {
            if (i > 0) {
                s = String.valueOf(s) + ",";
            }
            Coordinate coord = this.coordinates.get(i);
            s = String.valueOf(s) + "(" + coord.x + "," + coord.y + ")";
            ++i;
        }
        s = String.valueOf(s) + "]";
        return s;
    }
}

