/*
 * Decompiled with CFR 0.152.
 */
package com.mvw.allchemical.modifier;

import com.mvw.allchemical.Component;
import com.mvw.allchemical.ConditionalModifier;
import com.mvw.allchemical.Layout;
import com.mvw.allchemical.MixedStackModifier;
import com.mvw.allchemical.Modifier;
import com.mvw.allchemical.Recipe;
import com.mvw.allchemical.ResultModifier;
import java.util.ArrayList;
import java.util.Arrays;

public class IfModifier
extends Modifier
implements ConditionalModifier,
ResultModifier,
MixedStackModifier {
    protected ArrayList<Modifier> conditionMod = new ArrayList();
    protected ArrayList<Modifier> ifMod = new ArrayList();
    protected ArrayList<Modifier> elseMod = new ArrayList();

    @Override
    public ArrayList<Component> getResult(Recipe recipe, Layout layout) {
        for (Modifier modifier : this.conditionMod) {
            if (!(modifier instanceof ConditionalModifier) || ((ConditionalModifier)((Object)modifier)).canCombine(recipe, layout)) continue;
            return this.getResult(recipe, layout, this.elseMod);
        }
        return this.getResult(recipe, layout, this.ifMod);
    }

    protected ArrayList<Component> getResult(Recipe recipe, Layout layout, ArrayList<Modifier> modifiers) {
        ArrayList<Component> result = new ArrayList<Component>();
        for (Modifier modifier : modifiers) {
            if (!(modifier instanceof ResultModifier)) continue;
            result.addAll(((ResultModifier)((Object)modifier)).getResult(recipe, layout));
        }
        return result;
    }

    @Override
    public boolean canCombine(Recipe recipe, Layout layout) {
        for (Modifier modifier : this.conditionMod) {
            if (!(modifier instanceof ConditionalModifier) || ((ConditionalModifier)((Object)modifier)).canCombine(recipe, layout)) continue;
            return this.canCombine(recipe, layout, this.elseMod);
        }
        return this.canCombine(recipe, layout, this.ifMod);
    }

    protected boolean canCombine(Recipe recipe, Layout layout, ArrayList<Modifier> modifiers) {
        for (Modifier modifier : modifiers) {
            if (!(modifier instanceof ConditionalModifier) || ((ConditionalModifier)((Object)modifier)).canCombine(recipe, layout)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected Modifier getInstance(String string) {
        IfModifier modifier = new IfModifier();
        int index = 0;
        int startIndex = 0;
        int level = 0;
        int iteration = 0;
        String[] split = new String[]{"?", ":"};
        boolean found = false;
        while (!found) {
            int tagOpen = string.indexOf("[", index);
            int tagSplit = string.indexOf(split[iteration], index);
            if (level > 0) {
                tagSplit = string.indexOf("]", index);
            }
            if (tagSplit == -1) {
                if (iteration == 0) {
                    ++iteration;
                } else {
                    found = true;
                }
                startIndex = index;
                continue;
            }
            if (tagOpen > -1 && tagOpen < tagSplit) {
                ++level;
                index = tagOpen + 1;
                continue;
            }
            if (level > 0) {
                --level;
                continue;
            }
            if (iteration == 0) {
                modifier.conditionMod.addAll(Modifier.parseModifiers(string.substring(startIndex, tagSplit)));
                ++iteration;
                startIndex = index = tagSplit + 1;
                continue;
            }
            modifier.ifMod.addAll(Modifier.parseModifiers(string.substring(startIndex, tagSplit)));
            found = true;
        }
        if (this.ifMod.isEmpty()) {
            modifier.ifMod.addAll(Modifier.parseModifiers(string.substring(startIndex)));
        } else {
            modifier.elseMod.addAll(Modifier.parseModifiers(string.substring(startIndex)));
        }
        return modifier;
    }

    @Override
    protected Modifier getInstance(byte[] bytes) {
        IfModifier modifier = new IfModifier();
        int start = 0;
        int length = bytes[start] << 8 | bytes[start + 1];
        modifier.conditionMod = Modifier.parseModifiers(Arrays.copyOfRange(bytes, start + 2, start + length + 2));
        start = length + 2;
        length = bytes[start] << 8 | bytes[start + 1];
        modifier.ifMod = Modifier.parseModifiers(Arrays.copyOfRange(bytes, start + 2, start + length + 2));
        start = length + 2;
        length = bytes[start] << 8 | bytes[start + 1];
        modifier.elseMod = Modifier.parseModifiers(Arrays.copyOfRange(bytes, start + 2, start + length + 2));
        return modifier;
    }

    @Override
    protected byte[] getData() {
        byte[] cData = Modifier.getModifiersAsBytes(this.conditionMod);
        byte[] iData = Modifier.getModifiersAsBytes(this.ifMod);
        byte[] eData = Modifier.getModifiersAsBytes(this.elseMod);
        int length = cData.length + iData.length + eData.length;
        byte[] data = new byte[length + 4];
        data[0] = (byte)(this.id & 0xFF);
        data[1] = (byte)(this.id >> 8 & 0xFF);
        data[2] = (byte)(length & 0xFF);
        data[3] = (byte)(length >> 8 & 0xFF);
        int idx = 4;
        int i = 0;
        while (i < cData.length) {
            data[idx] = cData[i];
            ++idx;
            ++i;
        }
        i = 0;
        while (i < iData.length) {
            data[idx] = iData[i];
            ++idx;
            ++i;
        }
        i = 0;
        while (i < eData.length) {
            data[idx] = eData[i];
            ++idx;
            ++i;
        }
        return data;
    }

    public String toString() {
        Modifier modifier;
        String s = "";
        s = String.valueOf(s) + this.name;
        s = String.valueOf(s) + "[";
        int i = 0;
        while (i < this.conditionMod.size()) {
            if (i > 0) {
                s = String.valueOf(s) + "|";
            }
            modifier = this.conditionMod.get(i);
            s = String.valueOf(s) + modifier.toString();
            ++i;
        }
        s = String.valueOf(s) + "?";
        i = 0;
        while (i < this.ifMod.size()) {
            if (i > 0) {
                s = String.valueOf(s) + "|";
            }
            modifier = this.ifMod.get(i);
            s = String.valueOf(s) + modifier.toString();
            ++i;
        }
        s = String.valueOf(s) + ":";
        i = 0;
        while (i < this.elseMod.size()) {
            if (i > 0) {
                s = String.valueOf(s) + "|";
            }
            modifier = this.elseMod.get(i);
            s = String.valueOf(s) + modifier.toString();
            ++i;
        }
        s = String.valueOf(s) + "]";
        return s;
    }
}

