/*
 * Decompiled with CFR 0.152.
 */
package com.mvw.allchemical;

import com.mvw.allchemical.Component;
import com.mvw.allchemical.Content;
import com.mvw.allchemical.Coordinate;
import com.mvw.allchemical.Layout;
import com.mvw.allchemical.Modifier;
import com.mvw.allchemical.Result;
import com.mvw.allchemical.recipe.ShapelessRecipe;
import com.mvw.allchemical.recipe.SizelessRecipe;
import java.io.ByteArrayOutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public abstract class Recipe
implements Comparable<Recipe> {
    private static ArrayList<Recipe> recipeList = new ArrayList();
    protected static HashMap<Integer, Recipe> idTemplateMap = new HashMap();
    protected static HashMap<String, Recipe> nameTemplateMap = new HashMap();
    protected static HashMap<String, Integer> priorityMap = new HashMap();
    protected boolean consumes;
    protected Layout layout;
    protected ArrayList<Component> result;
    protected ArrayList<Modifier> modifiers;
    protected ArrayList<String> usageFlag;
    protected String name;
    protected int id;

    static {
        Recipe.addTemplate(0, "sizeless", new SizelessRecipe(), 100);
        Recipe.addTemplate(1, "shapeless", new ShapelessRecipe(), 200);
    }

    protected static void addTemplate(int id, String name, Recipe recipe, int priority) {
        recipe.id = id;
        recipe.name = name;
        idTemplateMap.put(id, recipe);
        nameTemplateMap.put(name, recipe);
        priorityMap.put(name, priority);
    }

    public static Recipe add(int id, Layout layout, ArrayList<Component> result) {
        return Recipe.add(id, layout, result, false);
    }

    public static Recipe add(int id, Layout layout, ArrayList<Component> result, boolean consumes) {
        return Recipe.add(id, layout, result, consumes, new ArrayList<Modifier>());
    }

    public static Recipe add(int id, Layout layout, ArrayList<Component> result, boolean consumes, ArrayList<Modifier> modifiers) {
        if (!idTemplateMap.containsKey(id)) {
            return null;
        }
        return Recipe.add(idTemplateMap.get(id), layout, result, consumes, modifiers);
    }

    public static Recipe add(String name, Layout layout, ArrayList<Component> result) {
        return Recipe.add(name, layout, result, false);
    }

    public static Recipe add(String name, Layout layout, ArrayList<Component> result, boolean consumes) {
        return Recipe.add(name, layout, result, consumes, new ArrayList<Modifier>());
    }

    public static Recipe add(String name, Layout layout, ArrayList<Component> result, boolean consumes, ArrayList<Modifier> modifiers) {
        if (!nameTemplateMap.containsKey(name)) {
            return null;
        }
        return Recipe.add(nameTemplateMap.get(name), layout, result, consumes, modifiers);
    }

    private static Recipe add(Recipe templateRecipe, Layout layout, ArrayList<Component> result, boolean consumes, ArrayList<Modifier> modifiers) {
        return Recipe.add(templateRecipe, layout, result, consumes, modifiers, new ArrayList<String>());
    }

    private static Recipe add(Recipe templateRecipe, Layout layout, ArrayList<Component> result, boolean consumes, ArrayList<Modifier> modifiers, ArrayList<String> usageFlag) {
        Recipe recipe = templateRecipe.add(layout, result, consumes, modifiers, usageFlag);
        recipe.id = templateRecipe.id;
        recipe.name = templateRecipe.name;
        recipeList.add(recipe);
        return recipe;
    }

    public static ArrayList<Recipe> getAll() {
        return new ArrayList<Recipe>(recipeList);
    }

    public static Result getResults(Layout layout) {
        return Recipe.getResults(layout, null);
    }

    /*
     * Unable to fully structure code
     */
    public static Result getResults(Layout layout, ArrayList<String> usageFlag) {
        result = new Result();
        used = new Layout(layout);
        Collections.sort(Recipe.recipeList, Collections.reverseOrder());
        unused = new boolean[used.getHeight()][used.getWidth()];
        consumeQuantity = new int[used.getHeight()][used.getWidth()];
        i = 0;
        while (i < used.getHeight() * used.getWidth()) {
            x = i % used.getWidth();
            y = i / used.getWidth();
            unused[y][x] = used.getAt(x, y) != null;
            ++i;
        }
        result.consumedComponents = unused;
        i = 0;
        while (i < Recipe.recipeList.size()) {
            block15: {
                block13: {
                    block14: {
                        recipe = Recipe.recipeList.get(i);
                        if (usageFlag == null) break block13;
                        v0 = hasFlag = usageFlag.isEmpty() != false && recipe.usageFlag.isEmpty() != false;
                        if (hasFlag) break block14;
                        if (!recipe.usageFlag.isEmpty() && !usageFlag.isEmpty()) {
                            for (String uFlag : usageFlag) {
                                if (!recipe.usageFlag.contains(uFlag)) continue;
                                hasFlag = true;
                                ** break;
                            }
                        }
                        break block15;
                    }
                    if (!hasFlag) break block15;
                }
                res = recipe.getResult(used, unused);
                if (!res.resultComponents.isEmpty()) {
                    result.resultComponents.addAll(res.resultComponents);
                    j = 0;
                    while (j < used.getHeight() * used.getWidth()) {
                        x = j % used.getWidth();
                        y = j / used.getWidth();
                        unused[y][x] = unused[y][x] != false && res.consumedComponents[y][x] != false;
                        consumeQuantity[y][x] = Math.max(consumeQuantity[y][x], res.quantity[y][x]);
                        if (recipe.consumes && !unused[y][x]) {
                            q = Math.max(0, consumeQuantity[y][x] - used.getQuantityAt(x, y));
                            consumeQuantity[y][x] = 0;
                            if (q > 0) {
                                used.setQuantity(q, x, y);
                            } else {
                                used.removeContent(x, y);
                            }
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        return result;
    }

    public Layout getLayout() {
        return new Layout(this.layout);
    }

    public ArrayList<Component> getRawResult() {
        return new ArrayList<Component>(this.result);
    }

    public Coordinate getSize() {
        return this.layout.getSize();
    }

    public ArrayList<Modifier> getModifiers() {
        return new ArrayList<Modifier>(this.modifiers);
    }

    public byte[] dumpData() {
        ByteArrayOutputStream dataStream = new ByteArrayOutputStream();
        dataStream.write(this.id & 0xFF);
        dataStream.write(this.id >> 8 & 0xFF);
        ByteArrayOutputStream subStream = new ByteArrayOutputStream();
        byte[] data = this.layout.dumpData();
        subStream.write(data, 0, data.length);
        data = Modifier.getComponentsAsBytes(this.result);
        subStream.write(data, 0, data.length);
        subStream.write(this.consumes ? 1 : 0);
        data = Modifier.getModifiersAsBytes(this.modifiers);
        subStream.write(data, 0, data.length);
        data = subStream.toByteArray();
        subStream.reset();
        dataStream.write(data.length & 0xFF);
        dataStream.write(data.length >> 8 & 0xFF);
        dataStream.write(data.length >> 16 & 0xFF);
        dataStream.write(data.length >> 24 & 0xFF);
        dataStream.write(data, 0, data.length);
        data = dataStream.toByteArray();
        dataStream.reset();
        return data;
    }

    public static byte[] dumpFullData() {
        byte[] data;
        Charset encoding = Charset.forName("UTF-8");
        ByteArrayOutputStream dataStream = new ByteArrayOutputStream();
        byte[] str = "RCP".getBytes(encoding);
        dataStream.write(str, 0, str.length);
        dataStream.write(0);
        ByteArrayOutputStream subStream = new ByteArrayOutputStream();
        subStream.write(recipeList.size() & 0xFF);
        subStream.write(recipeList.size() >> 8 & 0xFF);
        subStream.write(recipeList.size() >> 16 & 0xFF);
        subStream.write(recipeList.size() >> 24 & 0xFF);
        for (Recipe recipe : recipeList) {
            data = recipe.dumpData();
            subStream.write(data, 0, data.length);
        }
        data = subStream.toByteArray();
        subStream.reset();
        dataStream.write(data.length & 0xFF);
        dataStream.write(data.length >> 8 & 0xFF);
        dataStream.write(data.length >> 16 & 0xFF);
        dataStream.write(data.length >> 24 & 0xFF);
        dataStream.write(data, 0, data.length);
        data = dataStream.toByteArray();
        return data;
    }

    @Override
    public int compareTo(Recipe o) {
        if (this == o) {
            return 0;
        }
        if (this.consumes != o.consumes) {
            return this.consumes ? 1 : -1;
        }
        if (priorityMap.get(this.name) != priorityMap.get(o.name)) {
            return priorityMap.get(this.name) > priorityMap.get(o.name) ? 1 : -1;
        }
        Coordinate tSize = this.getSize();
        Coordinate oSize = o.getSize();
        if (tSize.x * tSize.y != oSize.x * oSize.y) {
            return tSize.x * tSize.y > oSize.x * oSize.y ? 1 : -1;
        }
        if (tSize.y != oSize.y) {
            return tSize.y > oSize.y ? 1 : -1;
        }
        if (tSize.x != oSize.x) {
            return tSize.x > oSize.x ? 1 : -1;
        }
        int y = 0;
        while (y < tSize.y) {
            int x = 0;
            while (x < tSize.x) {
                boolean oNull;
                Content tContent = this.layout.getAt(x, y);
                Content oContent = o.layout.getAt(x, y);
                boolean tNull = tContent == null;
                boolean bl = oNull = oContent == null;
                if (tNull != oNull) {
                    return oNull ? 1 : -1;
                }
                int comp = tContent.compareTo(oContent);
                if (comp != 0) {
                    return comp;
                }
                ++x;
            }
            ++y;
        }
        return 0;
    }

    protected abstract Recipe add(Layout var1, ArrayList<Component> var2, boolean var3, ArrayList<Modifier> var4, ArrayList<String> var5);

    public abstract Result getResult(Layout var1, boolean[][] var2);
}

