/*
 * Decompiled with CFR 0.152.
 */
package com.mvw.allchemical;

import com.mvw.allchemical.Attribute;
import com.mvw.allchemical.Component;
import com.mvw.allchemical.Content;
import com.mvw.allchemical.ContentStack;
import com.mvw.allchemical.Coordinate;
import com.mvw.allchemical.Group;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;

public class Layout {
    private int width;
    private int height;
    private Content[][] content;
    private int[][] quantity;
    private ArrayList<ContentStack> contentList = new ArrayList();
    private ArrayList<ContentStack> componentList = new ArrayList();
    private ArrayList<ContentStack> attributeList = new ArrayList();
    private ArrayList<ContentStack> groupList = new ArrayList();

    public Layout(int width, int height) {
        this.width = width;
        this.height = height;
        this.content = new Content[height][width];
        int i = 0;
        while (i < width * height) {
            int x = i % width;
            int y = i / width;
            this.content[y][x] = null;
            this.quantity[y][x] = 0;
            ++i;
        }
    }

    public Layout(Content[][] content) {
        this.width = content[0].length;
        this.height = content.length;
        this.content = content;
        this.quantity = new int[this.height][this.width];
        int i = 0;
        while (i < this.width * this.height) {
            int x = i % this.width;
            int y = i / this.width;
            Content c = this.getAt(x, y);
            if (c != null) {
                this.quantity[y][x] = 1;
                ContentStack s = new ContentStack(c, 1, new Coordinate(x, y), false);
                this.contentList.add(s);
                if (c instanceof Component) {
                    this.componentList.add(s);
                }
                if (c instanceof Attribute) {
                    this.attributeList.add(s);
                }
                if (c instanceof Group) {
                    this.groupList.add(s);
                }
            }
            ++i;
        }
    }

    public Layout(ArrayList<Content> content) {
        this(content.toArray(new Content[content.size()]));
    }

    public Layout(Content ... content) {
        this.width = content.length;
        this.height = 1;
        this.content = new Content[1][this.width];
        this.content[0] = content;
        this.quantity = new int[this.height][this.width];
        int i = 0;
        while (i < this.width) {
            Content c = this.getAt(i, 0);
            this.quantity[0][i] = 1;
            ContentStack s = new ContentStack(c, 1, new Coordinate(i, 0), false);
            this.contentList.add(s);
            if (c instanceof Component) {
                this.componentList.add(s);
            }
            if (c instanceof Attribute) {
                this.attributeList.add(s);
            }
            if (c instanceof Group) {
                this.groupList.add(s);
            }
            ++i;
        }
    }

    public Layout(Layout layout) {
        this.width = layout.width;
        this.height = layout.height;
        this.content = new Content[this.height][this.width];
        this.quantity = new int[this.height][this.width];
        int i = 0;
        while (i < this.width * this.height) {
            int x = i % this.width;
            int y = i / this.width;
            this.content[y][x] = layout.content[y][x];
            this.quantity[y][x] = layout.quantity[y][x];
            ++i;
        }
        this.contentList.addAll(layout.contentList);
        this.componentList.addAll(layout.componentList);
        this.attributeList.addAll(layout.attributeList);
        this.groupList.addAll(layout.groupList);
    }

    public void setContent(Content c, int x, int y) {
        if (this.content[y][x] != null) {
            this.removeContent(x, y);
        }
        this.content[y][x] = c;
        this.quantity[y][x] = 1;
        ContentStack s = new ContentStack(c, 1, new Coordinate(x, y), false);
        this.contentList.add(s);
        if (c instanceof Component) {
            this.componentList.add(s);
        }
        if (c instanceof Attribute) {
            this.attributeList.add(s);
        }
        if (c instanceof Group) {
            this.groupList.add(s);
        }
    }

    public void setQuantity(int q, int x, int y) {
        Content c = this.getAt(x, y);
        if (c != null) {
            ContentStack s;
            this.quantity[y][x] = q;
            int i = 0;
            while (i < this.contentList.size()) {
                s = this.contentList.get(i);
                if (s.coordinate.x == x && s.coordinate.y == y) {
                    s.quantity = q;
                    break;
                }
                ++i;
            }
            ArrayList<Object> sList = new ArrayList();
            if (c instanceof Component) {
                sList = this.componentList;
            }
            if (c instanceof Attribute) {
                sList = this.attributeList;
            }
            if (c instanceof Group) {
                sList = this.groupList;
            }
            int i2 = 0;
            while (i2 < sList.size()) {
                s = (ContentStack)sList.get(i2);
                if (s.coordinate.x == x && s.coordinate.y == y) {
                    s.quantity = q;
                    break;
                }
                ++i2;
            }
        }
    }

    public void removeContent(int x, int y) {
        ContentStack s;
        Content c = this.content[y][x];
        if (c == null) {
            return;
        }
        this.content[y][x] = null;
        int i = 0;
        while (i < this.contentList.size()) {
            s = this.contentList.get(i);
            if (s.coordinate.x == x && s.coordinate.y == y) {
                this.contentList.remove(i);
                break;
            }
            ++i;
        }
        ArrayList<Object> sList = new ArrayList();
        if (c instanceof Component) {
            sList = this.componentList;
        }
        if (c instanceof Attribute) {
            sList = this.attributeList;
        }
        if (c instanceof Group) {
            sList = this.groupList;
        }
        int i2 = 0;
        while (i2 < sList.size()) {
            s = (ContentStack)sList.get(i2);
            if (s.coordinate.x == x && s.coordinate.y == y) {
                sList.remove(i2);
                break;
            }
            ++i2;
        }
    }

    public void removeContent(boolean[][] keepList) {
        if (keepList.length != this.height || keepList[0].length != this.width) {
            return;
        }
        int y = 0;
        while (y < this.height) {
            int x = 0;
            while (x < this.width) {
                if (!keepList[y][x]) {
                    this.removeContent(x, y);
                }
                ++x;
            }
            ++y;
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Coordinate getSize() {
        return new Coordinate(this.width, this.height);
    }

    public Content getAt(int x, int y) {
        return this.content[y][x];
    }

    public int getQuantityAt(int x, int y) {
        return this.quantity[y][x];
    }

    public boolean isComponentAt(int x, int y) {
        if (this.content[y][x] == null) {
            return false;
        }
        return this.content[y][x] instanceof Component;
    }

    public int getContentSize() {
        return this.contentList.size();
    }

    public ArrayList<ContentStack> getContentList() {
        return new ArrayList<ContentStack>(this.contentList);
    }

    public ArrayList<ContentStack> getComponentList() {
        return new ArrayList<ContentStack>(this.componentList);
    }

    public ArrayList<ContentStack> getAttributeList() {
        return new ArrayList<ContentStack>(this.attributeList);
    }

    public ArrayList<ContentStack> getGroupList() {
        return new ArrayList<ContentStack>(this.groupList);
    }

    public Layout flip() {
        Content[][] newContent = new Content[this.height][this.width];
        int y = 0;
        while (y < this.height) {
            newContent[y] = this.content[this.height - y - 1];
            ++y;
        }
        return new Layout(newContent);
    }

    public Layout mirror() {
        Content[][] newContent = new Content[this.height][this.width];
        int y = 0;
        while (y < this.height) {
            int x = 0;
            while (x < this.width) {
                newContent[y][x] = this.content[y][this.width - x - 1];
                ++x;
            }
            ++y;
        }
        return new Layout(newContent);
    }

    public int hashCode() {
        int hash = 1;
        hash = hash * 11 + this.width;
        hash = hash * 13 + this.height;
        int y = 0;
        while (y < this.height) {
            int x = 0;
            while (x < this.width) {
                if (this.content[y][x] == null) {
                    hash *= 23;
                } else if (this.content[y][x] instanceof Component) {
                    Component component = (Component)this.content[y][x];
                    hash = hash * 31 + component.getId();
                } else {
                    Attribute attribute = (Attribute)this.content[y][x];
                    hash = hash * 29 + attribute.getId();
                }
                hash = hash * 3 + x;
                ++x;
            }
            hash = hash * 5 + y;
            ++y;
        }
        return hash;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Layout)) {
            return false;
        }
        Layout layout = (Layout)object;
        if (layout.hashCode() == this.hashCode()) {
            return true;
        }
        if (this.height != layout.height || this.width != layout.width) {
            return false;
        }
        int y = 0;
        while (y < this.height) {
            int x = 0;
            while (x < this.width) {
                if (this.content[y][x] != layout.content[y][x]) {
                    return false;
                }
                ++x;
            }
            ++y;
        }
        return true;
    }

    public String toString() {
        String s = "";
        int y = 0;
        while (y < this.height) {
            if (y > 0) {
                s = String.valueOf(s) + ",";
            }
            s = String.valueOf(s) + "[";
            int x = 0;
            while (x < this.width) {
                Content c;
                if (x > 0) {
                    s = String.valueOf(s) + ",";
                }
                if ((c = this.content[y][x]) == null) {
                    s = String.valueOf(s) + "-";
                } else {
                    if (c instanceof Component) {
                        s = String.valueOf(s) + "c:";
                    }
                    if (c instanceof Attribute) {
                        s = String.valueOf(s) + "a:";
                    }
                    if (c instanceof Group) {
                        s = String.valueOf(s) + "g:";
                    }
                    s = String.valueOf(s) + c.getName();
                }
                ++x;
            }
            s = String.valueOf(s) + "]";
            ++y;
        }
        return s;
    }

    public byte[] dumpData() {
        ByteArrayOutputStream dataStream = new ByteArrayOutputStream();
        dataStream.write(this.width & 0xFF);
        dataStream.write(this.width >> 8 & 0xFF);
        dataStream.write(this.height & 0xFF);
        dataStream.write(this.height >> 8 & 0xFF);
        int x = 0;
        while (x < this.width) {
            int y = 0;
            while (y < this.height) {
                int type = 0;
                int id = 0;
                Content c = this.getAt(x, y);
                int q = this.getQuantityAt(x, y);
                if (c instanceof Group) {
                    type = 1;
                }
                if (c instanceof Attribute) {
                    type = 2;
                }
                if (c instanceof Component) {
                    type = 3;
                }
                if (c != null) {
                    id = c.id;
                }
                dataStream.write(type & 0xFF);
                dataStream.write(id & 0xFF);
                dataStream.write(id >> 8 & 0xFF);
                dataStream.write(id >> 16 & 0xFF);
                dataStream.write(id >> 24 & 0xFF);
                dataStream.write(q & 0xFF);
                dataStream.write(q >> 8 & 0xFF);
                dataStream.write(q >> 16 & 0xFF);
                dataStream.write(q >> 24 & 0xFF);
                ++y;
            }
            ++x;
        }
        byte[] data = dataStream.toByteArray();
        dataStream.reset();
        return data;
    }

    public static void loadData(byte[] data) {
    }
}

