/*
 * Decompiled with CFR 0.152.
 */
package com.mvw.allchemical;

import com.mvw.allchemical.Attribute;
import com.mvw.allchemical.Content;
import com.mvw.allchemical.Group;
import java.io.ByteArrayOutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;

public class Component
extends Content {
    private static HashMap<Integer, Component> idMap = new HashMap();
    private static HashMap<String, Component> nameMap = new HashMap();
    private static HashMap<Group, ArrayList<Component>> perGroup = new HashMap();
    private static HashMap<Attribute, ArrayList<Component>> perAttribute = new HashMap();
    private static ArrayList<Component> componentList = new ArrayList();
    private Group group;
    private ArrayList<Attribute> attributes = new ArrayList();

    private Component(int id, String name, String realName, String description, Group group) {
        this.id = id;
        this.name = name;
        this.realName = realName;
        this.description = description;
        this.group = group;
        idMap.put(id, this);
        nameMap.put(name, this);
        if (!perGroup.containsKey(group)) {
            perGroup.put(group, new ArrayList());
        }
        perGroup.get(group).add(this);
        componentList.add(this);
    }

    @Override
    public int order() {
        return 3;
    }

    public static Component add(int id, String name, int group) {
        return Component.add(id, name, name, group);
    }

    public static Component add(int id, String name, String realName, int group) {
        return Component.add(id, name, realName, realName, group);
    }

    public static Component add(int id, String name, String realName, String description, int group) {
        Group g = Group.get(group);
        if (g == null) {
            return null;
        }
        return Component.add(id, name, realName, description, g);
    }

    public static Component add(int id, String name, String group) {
        return Component.add(id, name, name, group);
    }

    public static Component add(int id, String name, String realName, String group) {
        return Component.add(id, name, realName, realName, group);
    }

    public static Component add(int id, String name, String realName, String description, String group) {
        Group g = Group.get(group);
        if (g == null) {
            return null;
        }
        return Component.add(id, name, realName, description, g);
    }

    public static Component add(int id, String name, Group group) {
        return Component.add(id, name, name, group);
    }

    public static Component add(int id, String name, String realName, Group group) {
        return Component.add(id, name, realName, realName, group);
    }

    public static Component add(int id, String name, String realName, String description, Group group) {
        return new Component(id, name, realName, description, group);
    }

    public static void setAttributes(int id, Attribute ... attributes) {
        Component.setAttributes(id, new ArrayList<Attribute>(Arrays.asList(attributes)));
    }

    public static void setAttributes(int id, ArrayList<Attribute> attributes) {
        if (idMap.containsKey(id)) {
            Component.setAttributes(idMap.get(id), attributes);
        }
    }

    public static void setAttributes(String name, Attribute ... attributes) {
        Component.setAttributes(name, new ArrayList<Attribute>(Arrays.asList(attributes)));
    }

    public static void setAttributes(String name, ArrayList<Attribute> attributes) {
        if (nameMap.containsKey(name)) {
            Component.setAttributes(nameMap.get(name), attributes);
        }
    }

    public static void setAttributes(Component component, Attribute ... attributes) {
        Component.setAttributes(component, new ArrayList<Attribute>(Arrays.asList(attributes)));
    }

    public static void setAttributes(Component component, ArrayList<Attribute> attributes) {
        for (Attribute attribute : attributes) {
            if (!perAttribute.containsKey(attribute)) {
                perAttribute.put(attribute, new ArrayList());
            }
            if (perAttribute.get(attribute).contains(component)) continue;
            perAttribute.get(attribute).add(component);
        }
        component.attributes = attributes;
    }

    public static Component get(int id) {
        return idMap.get(id);
    }

    public static Component get(String name) {
        return nameMap.get(name);
    }

    public static ArrayList<Component> getAll() {
        return new ArrayList<Component>(componentList);
    }

    public static ArrayList<Component> getAllPerAttribute(String name) {
        Attribute attribute = Attribute.get(name);
        if (attribute == null) {
            return null;
        }
        return Component.getAllPerAttribute(attribute);
    }

    public static ArrayList<Component> getAllPerAttribute(int id) {
        Attribute attribute = Attribute.get(id);
        if (attribute == null) {
            return null;
        }
        return Component.getAllPerAttribute(attribute);
    }

    public static ArrayList<Component> getAllPerAttribute(Attribute attribute) {
        if (!perAttribute.containsKey(attribute)) {
            return new ArrayList<Component>();
        }
        return new ArrayList<Component>((Collection)perAttribute.get(attribute));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getRealName() {
        return this.realName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public Group getGroup() {
        return this.group;
    }

    public ArrayList<Attribute> getAttributes() {
        return new ArrayList<Attribute>(this.attributes);
    }

    @Override
    public byte[] dumpData() {
        byte[] data = super.dumpData();
        ByteArrayOutputStream dataStream = new ByteArrayOutputStream();
        dataStream.write(data, 0, data.length);
        dataStream.write(this.group.getId() & 0xFF);
        dataStream.write(this.group.getId() >> 8 & 0xFF);
        dataStream.write(this.group.getId() >> 16 & 0xFF);
        dataStream.write(this.group.getId() >> 24 & 0xFF);
        dataStream.write(this.attributes.size() & 0xFF);
        dataStream.write(this.attributes.size() >> 8 & 0xFF);
        dataStream.write(this.attributes.size() >> 16 & 0xFF);
        dataStream.write(this.attributes.size() >> 24 & 0xFF);
        for (Attribute attribute : this.attributes) {
            dataStream.write(attribute.getId() & 0xFF);
            dataStream.write(attribute.getId() >> 8 & 0xFF);
            dataStream.write(attribute.getId() >> 16 & 0xFF);
            dataStream.write(attribute.getId() >> 24 & 0xFF);
        }
        data = dataStream.toByteArray();
        dataStream.reset();
        return data;
    }

    public static byte[] dumpFullData() {
        Charset encoding = Charset.forName("UTF-8");
        ByteArrayOutputStream dataStream = new ByteArrayOutputStream();
        byte[] str = "CMP".getBytes(encoding);
        dataStream.write(str, 0, str.length);
        dataStream.write(0);
        ByteArrayOutputStream subDataStream = new ByteArrayOutputStream();
        subDataStream.write(componentList.size() & 0xFF);
        subDataStream.write(componentList.size() >> 8 & 0xFF);
        subDataStream.write(componentList.size() >> 16 & 0xFF);
        subDataStream.write(componentList.size() >> 24 & 0xFF);
        for (Component component : componentList) {
            byte[] subData = component.dumpData();
            subDataStream.write(subData.length & 0xFF);
            subDataStream.write(subData.length >> 8 & 0xFF);
            subDataStream.write(subData.length >> 16 & 0xFF);
            subDataStream.write(subData.length >> 24 & 0xFF);
            subDataStream.write(subData, 0, subData.length);
        }
        byte[] allSub = subDataStream.toByteArray();
        subDataStream.reset();
        dataStream.write(allSub.length & 0xFF);
        dataStream.write(allSub.length >> 8 & 0xFF);
        dataStream.write(allSub.length >> 16 & 0xFF);
        dataStream.write(allSub.length >> 24 & 0xFF);
        dataStream.write(allSub, 0, allSub.length);
        byte[] data = dataStream.toByteArray();
        dataStream.reset();
        return data;
    }
}

