/*
 * Decompiled with CFR 0.152.
 */
package com.mvw.allchemical;

import com.mvw.allchemical.Content;
import java.io.ByteArrayOutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;

public class Attribute
extends Content {
    private static HashMap<Integer, Attribute> idMap = new HashMap();
    private static HashMap<String, Attribute> nameMap = new HashMap();
    private static ArrayList<Attribute> attributeList = new ArrayList();

    private Attribute(int id, String name, String realName, String description) {
        this.id = id;
        this.name = name;
        this.realName = realName;
        this.description = description;
        idMap.put(id, this);
        nameMap.put(name, this);
        attributeList.add(this);
    }

    @Override
    public int order() {
        return 2;
    }

    public static Attribute add(int id, String name) {
        return Attribute.add(id, name, name);
    }

    public static Attribute add(int id, String name, String realName) {
        return Attribute.add(id, name, realName, realName);
    }

    public static Attribute add(int id, String name, String realName, String description) {
        return new Attribute(id, name, realName, description);
    }

    public static Attribute get(int id) {
        return idMap.get(id);
    }

    public static Attribute get(String name) {
        return nameMap.get(name);
    }

    public static ArrayList<Attribute> getAll() {
        return new ArrayList<Attribute>(attributeList);
    }

    @Override
    public byte[] dumpData() {
        return super.dumpData();
    }

    public static byte[] dumpFullData() {
        Charset encoding = Charset.forName("UTF-8");
        ByteArrayOutputStream dataStream = new ByteArrayOutputStream();
        byte[] str = "ATT".getBytes(encoding);
        dataStream.write(str, 0, str.length);
        dataStream.write(0);
        ByteArrayOutputStream subDataStream = new ByteArrayOutputStream();
        subDataStream.write(attributeList.size() & 0xFF);
        subDataStream.write(attributeList.size() >> 8 & 0xFF);
        subDataStream.write(attributeList.size() >> 16 & 0xFF);
        subDataStream.write(attributeList.size() >> 24 & 0xFF);
        for (Attribute att : attributeList) {
            byte[] subData = att.dumpData();
            subDataStream.write(subData.length & 0xFF);
            subDataStream.write(subData.length >> 8 & 0xFF);
            subDataStream.write(subData.length >> 16 & 0xFF);
            subDataStream.write(subData.length >> 24 & 0xFF);
            subDataStream.write(subData, 0, subData.length);
        }
        byte[] allSub = subDataStream.toByteArray();
        subDataStream.reset();
        dataStream.write(allSub.length & 0xFF);
        dataStream.write(allSub.length >> 8 & 0xFF);
        dataStream.write(allSub.length >> 16 & 0xFF);
        dataStream.write(allSub.length >> 24 & 0xFF);
        dataStream.write(allSub, 0, allSub.length);
        byte[] data = dataStream.toByteArray();
        dataStream.reset();
        return data;
    }
}

